
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `accessories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accessories` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category_id` int DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `qty` int NOT NULL DEFAULT '0',
  `requestable` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `location_id` int DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `purchase_cost` decimal(20,2) DEFAULT NULL,
  `order_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_id` int unsigned DEFAULT NULL,
  `min_amt` int DEFAULT NULL,
  `manufacturer_id` int DEFAULT NULL,
  `model_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `accessories_company_id_index` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accessories` WRITE;
/*!40000 ALTER TABLE `accessories` DISABLE KEYS */;
/*!40000 ALTER TABLE `accessories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accessories_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accessories_users` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `accessory_id` int DEFAULT NULL,
  `assigned_to` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accessories_users` WRITE;
/*!40000 ALTER TABLE `accessories_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `accessories_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `action_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `action_logs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `action_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `target_id` int DEFAULT NULL,
  `target_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_id` int DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `filename` text COLLATE utf8mb4_unicode_ci,
  `item_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `item_id` int NOT NULL,
  `expected_checkin` date DEFAULT NULL,
  `accepted_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `thread_id` int DEFAULT NULL,
  `company_id` int DEFAULT NULL,
  `accept_signature` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `log_meta` text COLLATE utf8mb4_unicode_ci,
  `action_date` datetime DEFAULT NULL,
  `stored_eula` text COLLATE utf8mb4_unicode_ci,
  `stored_eula_file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `action_logs_thread_id_index` (`thread_id`),
  KEY `action_logs_created_at_index` (`created_at`),
  KEY `action_logs_item_type_item_id_action_type_index` (`item_type`,`item_id`,`action_type`),
  KEY `action_logs_target_type_target_id_action_type_index` (`target_type`,`target_id`,`action_type`),
  KEY `action_logs_target_type_target_id_index` (`target_type`,`target_id`),
  KEY `action_logs_company_id_index` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=147 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `action_logs` WRITE;
/*!40000 ALTER TABLE `action_logs` DISABLE KEYS */;
INSERT INTO `action_logs` VALUES (1,1,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',1,NULL,NULL,'2021-02-23 11:36:33','2021-02-23 11:36:33',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(2,1,'checkout',11,'App\\Models\\User',NULL,'Checked out on asset creation',NULL,'App\\Models\\Asset',1,NULL,NULL,'2021-02-23 11:36:33','2021-02-23 11:36:33',NULL,NULL,NULL,NULL,NULL,'2021-02-23 11:36:33',NULL,NULL),(3,1,'add seats',NULL,NULL,NULL,'added 5 seats',NULL,'App\\Models\\License',1,NULL,NULL,'2021-03-04 13:26:12','2021-03-04 13:26:12',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(4,1,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\License',1,NULL,NULL,'2021-03-04 13:26:12','2021-03-04 13:26:12',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(5,1,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\License',1,NULL,NULL,'2021-03-04 13:30:04','2021-03-04 13:30:04',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(6,1,'checkout',21,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',1,NULL,NULL,'2021-03-04 13:30:17','2021-03-04 13:30:17',NULL,NULL,NULL,NULL,NULL,'2021-03-04 13:30:17',NULL,NULL),(7,1,'checkout',5,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',1,NULL,NULL,'2021-03-04 13:30:24','2021-03-04 13:30:24',NULL,NULL,NULL,NULL,NULL,'2021-03-04 13:30:24',NULL,NULL),(8,1,'checkout',23,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',1,NULL,NULL,'2021-03-04 14:00:34','2021-03-04 14:00:34',NULL,NULL,NULL,NULL,NULL,'2021-03-04 14:00:34',NULL,NULL),(9,1,'checkout',27,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',1,NULL,NULL,'2021-03-04 14:00:40','2021-03-04 14:00:40',NULL,NULL,NULL,NULL,NULL,'2021-03-04 14:00:40',NULL,NULL),(10,1,'add seats',NULL,NULL,NULL,'added 5 seats',NULL,'App\\Models\\License',2,NULL,NULL,'2021-03-04 14:01:54','2021-03-04 14:01:54',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(11,1,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\License',2,NULL,NULL,'2021-03-04 14:01:54','2021-03-04 14:01:54',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(12,1,'checkout',21,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',2,NULL,NULL,'2021-03-04 14:02:01','2021-03-04 14:02:01',NULL,NULL,NULL,NULL,NULL,'2021-03-04 14:02:01',NULL,NULL),(13,1,'add seats',NULL,NULL,NULL,'added 5 seats',NULL,'App\\Models\\License',3,NULL,NULL,'2021-03-04 14:03:36','2021-03-04 14:03:36',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(14,1,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\License',3,NULL,NULL,'2021-03-04 14:03:36','2021-03-04 14:03:36',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(15,1,'checkout',21,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',3,NULL,NULL,'2021-03-04 14:03:44','2021-03-04 14:03:44',NULL,NULL,NULL,NULL,NULL,'2021-03-04 14:03:44',NULL,NULL),(16,1,'add seats',NULL,NULL,NULL,'added 20 seats',NULL,'App\\Models\\License',4,NULL,NULL,'2021-03-04 14:05:01','2021-03-04 14:05:01',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(17,1,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\License',4,NULL,NULL,'2021-03-04 14:05:01','2021-03-04 14:05:01',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(18,1,'checkout',21,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',4,NULL,NULL,'2021-03-04 14:05:09','2021-03-04 14:05:09',NULL,NULL,NULL,NULL,NULL,'2021-03-04 14:05:09',NULL,NULL),(19,1,'add seats',NULL,NULL,NULL,'added 20 seats',NULL,'App\\Models\\License',5,NULL,NULL,'2021-03-04 14:20:00','2021-03-04 14:20:00',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(20,1,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\License',5,NULL,NULL,'2021-03-04 14:20:00','2021-03-04 14:20:00',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(21,1,'checkout',21,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',5,NULL,NULL,'2021-03-04 14:20:17','2021-03-04 14:20:17',NULL,NULL,NULL,NULL,NULL,'2021-03-04 14:20:17',NULL,NULL),(22,1,'checkout',23,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',5,NULL,NULL,'2021-03-04 14:20:27','2021-03-04 14:20:27',NULL,NULL,NULL,NULL,NULL,'2021-03-04 14:20:27',NULL,NULL),(23,1,'add seats',NULL,NULL,NULL,'added 5 seats',NULL,'App\\Models\\License',6,NULL,NULL,'2021-03-05 09:08:48','2021-03-05 09:08:48',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(24,1,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\License',6,NULL,NULL,'2021-03-05 09:08:48','2021-03-05 09:08:48',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(25,1,'checkout',23,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',6,NULL,NULL,'2021-03-05 09:08:57','2021-03-05 09:08:57',NULL,NULL,NULL,NULL,NULL,'2021-03-05 09:08:57',NULL,NULL),(26,1,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',2,NULL,NULL,'2021-04-27 08:12:23','2021-04-27 08:12:23',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(27,1,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',3,NULL,NULL,'2021-07-12 10:13:42','2021-07-12 10:13:42',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(28,1,'checkout',6,'App\\Models\\User',NULL,'Checked out on asset creation',NULL,'App\\Models\\Asset',3,NULL,NULL,'2021-07-12 10:13:42','2021-07-12 10:13:42',NULL,NULL,NULL,NULL,NULL,'2021-07-12 11:13:42',NULL,NULL),(29,1,'checkin from',6,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\Asset',3,NULL,NULL,'2021-07-12 11:28:01','2021-07-12 11:28:01',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(30,1,'checkout',21,'App\\Models\\User',NULL,'',NULL,'App\\Models\\Asset',3,NULL,NULL,'2021-07-12 11:28:13','2021-07-12 11:28:13',NULL,NULL,NULL,NULL,NULL,'2021-07-12 12:28:13',NULL,NULL),(31,1,'checkin from',23,'App\\Models\\User',NULL,'Bulk checkin items and delete user',NULL,'App\\Models\\LicenseSeat',3,NULL,NULL,'2021-10-07 12:06:48','2021-10-07 12:06:48',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(32,1,'checkin from',23,'App\\Models\\User',NULL,'Bulk checkin items and delete user',NULL,'App\\Models\\LicenseSeat',37,NULL,NULL,'2021-10-07 12:06:49','2021-10-07 12:06:49',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(33,1,'checkin from',23,'App\\Models\\User',NULL,'Bulk checkin items and delete user',NULL,'App\\Models\\LicenseSeat',56,NULL,NULL,'2021-10-07 12:06:50','2021-10-07 12:06:50',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(34,1,'checkin from',21,'App\\Models\\User',NULL,'Bulk checkin items and delete user',NULL,'App\\Models\\Asset',3,NULL,NULL,'2021-10-07 12:07:14','2021-10-07 12:07:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(35,1,'checkin from',21,'App\\Models\\User',NULL,'Bulk checkin items and delete user',NULL,'App\\Models\\LicenseSeat',1,NULL,NULL,'2021-10-07 12:07:14','2021-10-07 12:07:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(36,1,'checkin from',21,'App\\Models\\User',NULL,'Bulk checkin items and delete user',NULL,'App\\Models\\LicenseSeat',6,NULL,NULL,'2021-10-07 12:07:15','2021-10-07 12:07:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(37,1,'checkin from',21,'App\\Models\\User',NULL,'Bulk checkin items and delete user',NULL,'App\\Models\\LicenseSeat',11,NULL,NULL,'2021-10-07 12:07:15','2021-10-07 12:07:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(38,1,'checkin from',21,'App\\Models\\User',NULL,'Bulk checkin items and delete user',NULL,'App\\Models\\LicenseSeat',16,NULL,NULL,'2021-10-07 12:07:15','2021-10-07 12:07:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(39,1,'checkin from',21,'App\\Models\\User',NULL,'Bulk checkin items and delete user',NULL,'App\\Models\\LicenseSeat',36,NULL,NULL,'2021-10-07 12:07:15','2021-10-07 12:07:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(40,1,'add seats',NULL,NULL,NULL,'added 5 seats',NULL,'App\\Models\\License',7,NULL,NULL,'2021-10-12 12:12:16','2021-10-12 12:12:16',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(41,1,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\License',7,NULL,NULL,'2021-10-12 12:12:16','2021-10-12 12:12:16',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(42,1,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\License',7,NULL,NULL,'2021-10-12 12:12:56','2021-10-12 12:12:56',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(43,1,'checkout',48,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',7,NULL,NULL,'2021-10-12 12:13:33','2021-10-12 12:13:33',NULL,NULL,NULL,NULL,NULL,'2021-10-12 13:13:33',NULL,NULL),(44,1,'checkout',48,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',6,NULL,NULL,'2021-10-12 12:13:55','2021-10-12 12:13:55',NULL,NULL,NULL,NULL,NULL,'2021-10-12 13:13:55',NULL,NULL),(45,1,'checkout',48,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',2,NULL,NULL,'2021-10-12 12:14:09','2021-10-12 12:14:09',NULL,NULL,NULL,NULL,NULL,'2021-10-12 13:14:09',NULL,NULL),(46,1,'checkout',27,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',5,NULL,NULL,'2021-10-12 12:14:22','2021-10-12 12:14:22',NULL,NULL,NULL,NULL,NULL,'2021-10-12 13:14:22',NULL,NULL),(47,1,'checkout',51,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',5,NULL,NULL,'2021-10-12 12:14:34','2021-10-12 12:14:34',NULL,NULL,NULL,NULL,NULL,'2021-10-12 13:14:34',NULL,NULL),(48,1,'checkout',48,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',5,NULL,NULL,'2021-10-12 12:14:42','2021-10-12 12:14:42',NULL,NULL,NULL,NULL,NULL,'2021-10-12 13:14:42',NULL,NULL),(49,1,'checkout',48,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',1,NULL,NULL,'2021-10-12 12:14:57','2021-10-12 12:14:57',NULL,NULL,NULL,NULL,NULL,'2021-10-12 13:14:57',NULL,NULL),(50,1,'checkout',27,'App\\Models\\User',NULL,'jackmorris',NULL,'App\\Models\\License',7,NULL,NULL,'2021-10-12 12:15:58','2021-10-12 12:15:58',NULL,NULL,NULL,NULL,NULL,'2021-10-12 13:15:58',NULL,NULL),(51,1,'add seats',NULL,NULL,NULL,'added 22 seats',NULL,'App\\Models\\License',8,NULL,NULL,'2021-10-14 09:06:07','2021-10-14 09:06:07',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(52,1,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\License',8,NULL,NULL,'2021-10-14 09:06:07','2021-10-14 09:06:07',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(53,1,'checkout',48,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',8,NULL,NULL,'2021-10-14 09:06:16','2021-10-14 09:06:16',NULL,NULL,NULL,NULL,NULL,'2021-10-14 10:06:16',NULL,NULL),(54,1,'checkout',27,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',8,NULL,NULL,'2021-10-14 09:06:27','2021-10-14 09:06:27',NULL,NULL,NULL,NULL,NULL,'2021-10-14 10:06:27',NULL,NULL),(55,1,'checkout',51,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',8,NULL,NULL,'2021-10-14 09:10:56','2021-10-14 09:10:56',NULL,NULL,NULL,NULL,NULL,'2021-10-14 10:10:56',NULL,NULL),(56,1,'checkout',31,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',8,NULL,NULL,'2021-10-14 09:11:15','2021-10-14 09:11:15',NULL,NULL,NULL,NULL,NULL,'2021-10-14 10:11:15',NULL,NULL),(57,1,'checkout',24,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',8,NULL,NULL,'2021-10-14 09:11:22','2021-10-14 09:11:22',NULL,NULL,NULL,NULL,NULL,'2021-10-14 10:11:22',NULL,NULL),(58,1,'add seats',NULL,NULL,NULL,'added 8 seats',NULL,'App\\Models\\License',9,NULL,NULL,'2021-10-14 10:39:36','2021-10-14 10:39:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(59,1,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\License',9,NULL,NULL,'2021-10-14 10:39:36','2021-10-14 10:39:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(60,1,'add seats',NULL,NULL,NULL,'added 5 seats',NULL,'App\\Models\\License',10,NULL,NULL,'2021-10-14 10:40:31','2021-10-14 10:40:31',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(61,1,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\License',10,NULL,NULL,'2021-10-14 10:40:31','2021-10-14 10:40:31',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(62,1,'checkout',27,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',9,NULL,NULL,'2021-10-14 10:40:39','2021-10-14 10:40:39',NULL,NULL,NULL,NULL,NULL,'2021-10-14 11:40:39',NULL,NULL),(63,1,'checkin from',27,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',1,NULL,NULL,'2022-05-18 14:13:28','2022-05-18 14:13:28',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(64,1,'checkin from',27,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',5,NULL,NULL,'2022-05-18 14:13:46','2022-05-18 14:13:46',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(65,1,'checkin from',27,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',7,NULL,NULL,'2022-05-18 14:13:52','2022-05-18 14:13:52',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(66,1,'checkin from',27,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',8,NULL,NULL,'2022-05-18 14:13:55','2022-05-18 14:13:55',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(67,1,'checkin from',27,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',9,NULL,NULL,'2022-05-18 14:13:58','2022-05-18 14:13:58',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(68,1,'checkout',6,'App\\Models\\User',NULL,'',NULL,'App\\Models\\Asset',3,NULL,NULL,'2022-05-18 14:29:55','2022-05-18 14:29:55',NULL,NULL,NULL,NULL,NULL,'2022-05-18 15:29:55',NULL,NULL),(69,1,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',3,NULL,NULL,'2022-05-18 14:29:55','2022-05-18 14:29:55',NULL,NULL,1,NULL,'{\"checkout_counter\":{\"old\":2,\"new\":3}}',NULL,NULL,NULL),(70,1,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',3,NULL,NULL,'2022-05-18 14:30:33','2022-05-18 14:30:33',NULL,NULL,1,NULL,'{\"name\":{\"old\":null,\"new\":\"Fluke 107 Multimeter\"}}',NULL,NULL,NULL),(71,1,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',2,NULL,NULL,'2022-05-18 14:32:09','2022-05-18 14:32:09',NULL,NULL,1,NULL,'{\"name\":{\"old\":null,\"new\":\"Corrugated Tube Cutter\"},\"purchase_date\":{\"old\":\"2021-03-26T00:00:00.000000Z\",\"new\":\"2021-03-26\"}}',NULL,NULL,NULL),(72,55,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',4,NULL,NULL,'2022-06-01 14:40:14','2022-06-01 14:40:14',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(73,55,'checkout',4,'App\\Models\\Location',4,'Checked out on asset creation',NULL,'App\\Models\\Asset',4,NULL,NULL,'2022-06-01 14:40:14','2022-06-01 14:40:14',NULL,NULL,NULL,NULL,NULL,'2022-06-01 15:40:14',NULL,NULL),(74,55,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',4,NULL,NULL,'2022-06-01 14:40:14','2022-06-01 14:40:14',NULL,NULL,1,NULL,'{\"purchase_date\":{\"old\":\"2022-05-20T00:00:00.000000Z\",\"new\":\"2022-05-20\"}}',NULL,NULL,NULL),(75,55,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',5,NULL,NULL,'2022-06-01 14:43:58','2022-06-01 14:43:58',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(76,55,'checkout',4,'App\\Models\\Asset',4,'Checked out on asset creation',NULL,'App\\Models\\Asset',5,NULL,NULL,'2022-06-01 14:43:58','2022-06-01 14:43:58',NULL,NULL,1,NULL,NULL,'2022-06-01 15:43:58',NULL,NULL),(77,55,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',5,NULL,NULL,'2022-06-01 14:43:58','2022-06-01 14:43:58',NULL,NULL,1,NULL,'{\"purchase_date\":{\"old\":\"2022-05-16T00:00:00.000000Z\",\"new\":\"2022-05-16\"}}',NULL,NULL,NULL),(78,55,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',6,NULL,NULL,'2022-06-01 15:05:41','2022-06-01 15:05:41',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(79,55,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',6,NULL,NULL,'2022-06-01 15:07:30','2022-06-01 15:07:30',NULL,NULL,1,NULL,'{\"model_id\":{\"old\":7,\"new\":\"8\"}}',NULL,NULL,NULL),(80,55,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',7,NULL,NULL,'2022-06-06 12:48:15','2022-06-06 12:48:15',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(81,55,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',7,NULL,NULL,'2022-06-06 12:48:39','2022-06-06 12:48:39',NULL,NULL,1,NULL,'{\"name\":{\"old\":null,\"new\":\"CCTV Tester\"}}',NULL,NULL,NULL),(82,55,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',6,NULL,NULL,'2022-06-06 12:49:13','2022-06-06 12:49:13',NULL,NULL,1,NULL,'{\"name\":{\"old\":\"CCTV test monitor with UTC\",\"new\":\"CCTV tester with UTC\"}}',NULL,NULL,NULL),(83,55,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',7,NULL,NULL,'2022-06-06 12:49:28','2022-06-06 12:49:28',NULL,NULL,1,NULL,'{\"name\":{\"old\":\"CCTV Tester\",\"new\":\"CCTV Tester with UTC\"}}',NULL,NULL,NULL),(84,55,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',7,NULL,NULL,'2022-06-06 12:50:02','2022-06-06 12:50:02',NULL,NULL,1,NULL,'{\"rtd_location_id\":{\"old\":null,\"new\":\"1\"},\"location_id\":{\"old\":null,\"new\":\"1\"}}',NULL,NULL,NULL),(85,55,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',8,NULL,NULL,'2022-06-06 12:52:46','2022-06-06 12:52:46',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(86,55,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',9,NULL,NULL,'2022-06-06 12:54:48','2022-06-06 12:54:48',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(87,55,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',10,NULL,NULL,'2022-06-06 12:59:18','2022-06-06 12:59:18',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(88,55,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',11,NULL,NULL,'2022-06-06 13:02:50','2022-06-06 13:02:50',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(89,55,'checkout',6,'App\\Models\\Location',6,'Checked out on asset creation',NULL,'App\\Models\\Asset',11,NULL,NULL,'2022-06-06 13:02:50','2022-06-06 13:02:50',NULL,NULL,NULL,NULL,NULL,'2022-06-06 14:02:50',NULL,NULL),(90,55,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',11,NULL,NULL,'2022-06-06 13:02:50','2022-06-06 13:02:50',NULL,NULL,1,NULL,'[]',NULL,NULL,NULL),(91,55,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',12,NULL,NULL,'2022-06-06 13:13:30','2022-06-06 13:13:30',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(92,55,'checkout',5,'App\\Models\\Location',5,'Checked out on asset creation',NULL,'App\\Models\\Asset',12,NULL,NULL,'2022-06-06 13:13:30','2022-06-06 13:13:30',NULL,NULL,NULL,NULL,NULL,'2022-06-06 14:13:30',NULL,NULL),(93,55,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',12,NULL,NULL,'2022-06-06 13:13:30','2022-06-06 13:13:30',NULL,NULL,1,NULL,'[]',NULL,NULL,NULL),(94,55,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',13,NULL,NULL,'2022-06-06 13:15:34','2022-06-06 13:15:34',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(95,55,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',12,NULL,NULL,'2022-06-06 13:44:21','2022-06-06 13:44:21',NULL,NULL,1,NULL,'{\"asset_tag\":{\"old\":\"A00149\",\"new\":\"A000149\"}}',NULL,NULL,NULL),(96,55,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',14,NULL,NULL,'2022-06-06 13:44:53','2022-06-06 13:44:53',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(97,55,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',15,NULL,NULL,'2022-06-06 13:47:50','2022-06-06 13:47:50',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(98,55,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',14,NULL,NULL,'2022-06-06 13:49:26','2022-06-06 13:49:26',NULL,NULL,1,NULL,'{\"rtd_location_id\":{\"old\":null,\"new\":\"1\"},\"location_id\":{\"old\":null,\"new\":\"1\"}}',NULL,NULL,NULL),(99,55,'checkout',16,'App\\Models\\User',NULL,'',NULL,'App\\Models\\Asset',6,NULL,NULL,'2022-06-06 14:20:21','2022-06-06 14:20:21',NULL,NULL,NULL,NULL,NULL,'2022-06-06 15:20:21',NULL,NULL),(100,55,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',6,NULL,NULL,'2022-06-06 14:20:21','2022-06-06 14:20:21',NULL,NULL,1,NULL,'{\"checkout_counter\":{\"old\":0,\"new\":1}}',NULL,NULL,NULL),(101,55,'checkout',49,'App\\Models\\User',NULL,'',NULL,'App\\Models\\Asset',7,NULL,NULL,'2022-06-06 14:21:28','2022-06-06 14:21:28',NULL,NULL,NULL,NULL,NULL,'2022-06-06 15:21:27',NULL,NULL),(102,55,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',7,NULL,NULL,'2022-06-06 14:21:28','2022-06-06 14:21:28',NULL,NULL,1,NULL,'{\"checkout_counter\":{\"old\":0,\"new\":1}}',NULL,NULL,NULL),(103,55,'checkout',13,'App\\Models\\User',NULL,'',NULL,'App\\Models\\Asset',8,NULL,NULL,'2022-06-06 14:22:38','2022-06-06 14:22:38',NULL,NULL,NULL,NULL,NULL,'2022-06-06 15:22:38',NULL,NULL),(104,55,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',8,NULL,NULL,'2022-06-06 14:22:38','2022-06-06 14:22:38',NULL,NULL,1,NULL,'{\"checkout_counter\":{\"old\":0,\"new\":1}}',NULL,NULL,NULL),(105,55,'checkout',18,'App\\Models\\User',NULL,'',NULL,'App\\Models\\Asset',9,NULL,NULL,'2022-06-06 14:23:36','2022-06-06 14:23:36',NULL,NULL,NULL,NULL,NULL,'2022-06-06 15:23:36',NULL,NULL),(106,55,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',9,NULL,NULL,'2022-06-06 14:23:36','2022-06-06 14:23:36',NULL,NULL,1,NULL,'{\"checkout_counter\":{\"old\":0,\"new\":1}}',NULL,NULL,NULL),(107,55,'checkout',19,'App\\Models\\User',NULL,'',NULL,'App\\Models\\Asset',10,NULL,NULL,'2022-06-06 14:24:25','2022-06-06 14:24:25',NULL,NULL,NULL,NULL,NULL,'2022-06-06 15:24:25',NULL,NULL),(108,55,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',10,NULL,NULL,'2022-06-06 14:24:25','2022-06-06 14:24:25',NULL,NULL,1,NULL,'{\"checkout_counter\":{\"old\":0,\"new\":1}}',NULL,NULL,NULL),(109,55,'checkout',54,'App\\Models\\User',NULL,'',NULL,'App\\Models\\Asset',13,NULL,NULL,'2022-06-06 14:25:42','2022-06-06 14:25:42',NULL,NULL,NULL,NULL,NULL,'2022-06-06 15:25:42',NULL,NULL),(110,55,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',13,NULL,NULL,'2022-06-06 14:25:42','2022-06-06 14:25:42',NULL,NULL,1,NULL,'{\"checkout_counter\":{\"old\":0,\"new\":1}}',NULL,NULL,NULL),(111,55,'checkout',14,'App\\Models\\User',NULL,'',NULL,'App\\Models\\Asset',14,NULL,NULL,'2022-06-06 14:26:48','2022-06-06 14:26:48',NULL,NULL,NULL,NULL,NULL,'2022-06-06 15:26:48',NULL,NULL),(112,55,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',14,NULL,NULL,'2022-06-06 14:26:48','2022-06-06 14:26:48',NULL,NULL,1,NULL,'{\"checkout_counter\":{\"old\":0,\"new\":1}}',NULL,NULL,NULL),(113,55,'checkout',15,'App\\Models\\User',NULL,'',NULL,'App\\Models\\Asset',15,NULL,NULL,'2022-06-06 14:27:31','2022-06-06 14:27:31',NULL,NULL,NULL,NULL,NULL,'2022-06-06 15:27:31',NULL,NULL),(114,55,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',15,NULL,NULL,'2022-06-06 14:27:31','2022-06-06 14:27:31',NULL,NULL,1,NULL,'{\"checkout_counter\":{\"old\":0,\"new\":1}}',NULL,NULL,NULL),(115,55,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',16,NULL,NULL,'2022-06-06 14:29:14','2022-06-06 14:29:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(116,55,'checkout',11,'App\\Models\\User',1,'Checked out on asset creation',NULL,'App\\Models\\Asset',16,NULL,NULL,'2022-06-06 14:29:14','2022-06-06 14:29:14',NULL,NULL,NULL,NULL,NULL,'2022-06-06 15:29:14',NULL,NULL),(117,55,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',16,NULL,NULL,'2022-06-06 14:29:14','2022-06-06 14:29:14',NULL,NULL,NULL,NULL,'[]',NULL,NULL,NULL),(118,55,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',17,NULL,NULL,'2022-06-06 14:51:54','2022-06-06 14:51:54',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(119,55,'checkout',2,'App\\Models\\Location',2,'Checked out on asset creation',NULL,'App\\Models\\Asset',17,NULL,NULL,'2022-06-06 14:51:54','2022-06-06 14:51:54',NULL,NULL,NULL,NULL,NULL,'2022-06-06 15:51:54',NULL,NULL),(120,55,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',17,NULL,NULL,'2022-06-06 14:51:54','2022-06-06 14:51:54',NULL,NULL,1,NULL,'[]',NULL,NULL,NULL),(121,55,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',18,NULL,NULL,'2022-06-06 14:53:24','2022-06-06 14:53:24',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(122,55,'checkout',17,'App\\Models\\Asset',2,'Checked out on asset creation',NULL,'App\\Models\\Asset',18,NULL,NULL,'2022-06-06 14:53:24','2022-06-06 14:53:24',NULL,NULL,1,NULL,NULL,'2022-06-06 15:53:24',NULL,NULL),(123,55,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',18,NULL,NULL,'2022-06-06 14:53:24','2022-06-06 14:53:24',NULL,NULL,1,NULL,'[]',NULL,NULL,NULL),(124,55,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',19,NULL,NULL,'2022-06-08 13:45:08','2022-06-08 13:45:08',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(125,55,'checkout',10,'App\\Models\\Location',10,'Checked out on asset creation',NULL,'App\\Models\\Asset',19,NULL,NULL,'2022-06-08 13:45:08','2022-06-08 13:45:08',NULL,NULL,NULL,NULL,NULL,'2022-06-08 14:45:08',NULL,NULL),(126,55,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',19,NULL,NULL,'2022-06-08 13:45:08','2022-06-08 13:45:08',NULL,NULL,1,NULL,'[]',NULL,NULL,NULL),(127,55,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Component',1,NULL,NULL,'2022-06-08 14:40:51','2022-06-08 14:40:51',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(128,55,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',20,NULL,NULL,'2022-06-08 14:42:38','2022-06-08 14:42:38',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(129,55,'checkout',9,'App\\Models\\Location',9,'Checked out on asset creation',NULL,'App\\Models\\Asset',20,NULL,NULL,'2022-06-08 14:42:38','2022-06-08 14:42:38',NULL,NULL,NULL,NULL,NULL,'2022-06-08 15:42:38',NULL,NULL),(130,55,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',20,NULL,NULL,'2022-06-08 14:42:38','2022-06-08 14:42:38',NULL,NULL,1,NULL,'[]',NULL,NULL,NULL),(131,55,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',21,NULL,NULL,'2022-06-08 14:43:30','2022-06-08 14:43:30',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(132,55,'checkout',9,'App\\Models\\Location',9,'Checked out on asset creation',NULL,'App\\Models\\Asset',21,NULL,NULL,'2022-06-08 14:43:30','2022-06-08 14:43:30',NULL,NULL,NULL,NULL,NULL,'2022-06-08 15:43:30',NULL,NULL),(133,55,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',21,NULL,NULL,'2022-06-08 14:43:30','2022-06-08 14:43:30',NULL,NULL,1,NULL,'[]',NULL,NULL,NULL),(134,55,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',22,NULL,NULL,'2022-06-08 14:44:22','2022-06-08 14:44:22',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(135,55,'checkout',9,'App\\Models\\Location',9,'Checked out on asset creation',NULL,'App\\Models\\Asset',22,NULL,NULL,'2022-06-08 14:44:22','2022-06-08 14:44:22',NULL,NULL,NULL,NULL,NULL,'2022-06-08 15:44:22',NULL,NULL),(136,55,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',22,NULL,NULL,'2022-06-08 14:44:22','2022-06-08 14:44:22',NULL,NULL,1,NULL,'[]',NULL,NULL,NULL),(137,1,'add seats',NULL,NULL,NULL,'added 12 seats',NULL,'App\\Models\\License',11,NULL,NULL,'2022-07-06 12:46:36','2022-07-06 12:46:36',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(138,1,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\License',11,NULL,NULL,'2022-07-06 12:46:36','2022-07-06 12:46:36',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(139,1,'checkout',55,'App\\Models\\User',6,NULL,NULL,'App\\Models\\License',11,NULL,NULL,'2022-07-06 12:47:31','2022-07-06 12:47:31',NULL,NULL,1,NULL,NULL,'2022-07-06 13:47:31',NULL,NULL),(140,1,'checkout',48,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',11,NULL,NULL,'2022-07-06 12:47:42','2022-07-06 12:47:42',NULL,NULL,NULL,NULL,NULL,'2022-07-06 13:47:42',NULL,NULL),(141,1,'checkout',6,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',11,NULL,NULL,'2022-07-06 12:47:52','2022-07-06 12:47:52',NULL,NULL,NULL,NULL,NULL,'2022-07-06 13:47:52',NULL,NULL),(142,1,'checkout',51,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',1,NULL,NULL,'2022-07-06 12:48:28','2022-07-06 12:48:28',NULL,NULL,NULL,NULL,NULL,'2022-07-06 13:48:28',NULL,NULL),(143,1,'checkout',48,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\License',1,NULL,NULL,'2022-07-06 12:48:45','2022-07-06 12:48:45',NULL,NULL,NULL,NULL,NULL,'2022-07-06 13:48:45',NULL,NULL),(144,1,'add seats',NULL,NULL,NULL,'added 5 seats',NULL,'App\\Models\\License',1,NULL,NULL,'2022-07-06 12:49:09','2022-07-06 12:49:09',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(145,1,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\License',1,NULL,NULL,'2022-07-06 12:49:09','2022-07-06 12:49:09',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL),(146,1,'checkout',55,'App\\Models\\User',6,NULL,NULL,'App\\Models\\License',1,NULL,NULL,'2022-07-06 12:49:19','2022-07-06 12:49:19',NULL,NULL,1,NULL,NULL,'2022-07-06 13:49:19',NULL,NULL);
/*!40000 ALTER TABLE `action_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `asset_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `asset_logs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `action_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `asset_id` int NOT NULL,
  `checkedout_to` int DEFAULT NULL,
  `location_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `asset_type` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `filename` text COLLATE utf8mb4_unicode_ci,
  `requested_at` datetime DEFAULT NULL,
  `accepted_at` datetime DEFAULT NULL,
  `accessory_id` int DEFAULT NULL,
  `accepted_id` int DEFAULT NULL,
  `consumable_id` int DEFAULT NULL,
  `expected_checkin` date DEFAULT NULL,
  `component_id` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `asset_logs` WRITE;
/*!40000 ALTER TABLE `asset_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `asset_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `asset_maintenances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `asset_maintenances` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL,
  `supplier_id` int unsigned NOT NULL,
  `asset_maintenance_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_warranty` tinyint(1) NOT NULL,
  `start_date` date NOT NULL,
  `completion_date` date DEFAULT NULL,
  `asset_maintenance_time` int DEFAULT NULL,
  `notes` longtext COLLATE utf8mb4_unicode_ci,
  `cost` decimal(20,2) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `asset_maintenances` WRITE;
/*!40000 ALTER TABLE `asset_maintenances` DISABLE KEYS */;
/*!40000 ALTER TABLE `asset_maintenances` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `asset_uploads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `asset_uploads` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `filename` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `asset_id` int NOT NULL,
  `filenotes` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `asset_uploads` WRITE;
/*!40000 ALTER TABLE `asset_uploads` DISABLE KEYS */;
/*!40000 ALTER TABLE `asset_uploads` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `asset_tag` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `model_id` int DEFAULT NULL,
  `serial` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `purchase_cost` decimal(20,2) DEFAULT NULL,
  `order_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `assigned_to` int DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `image` text COLLATE utf8mb4_unicode_ci,
  `user_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `physical` tinyint(1) NOT NULL DEFAULT '1',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `status_id` int DEFAULT NULL,
  `archived` tinyint(1) DEFAULT '0',
  `warranty_months` int DEFAULT NULL,
  `depreciate` tinyint(1) DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `requestable` tinyint NOT NULL DEFAULT '0',
  `rtd_location_id` int DEFAULT NULL,
  `_snipeit_mac_address_1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `accepted` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_checkout` datetime DEFAULT NULL,
  `expected_checkin` date DEFAULT NULL,
  `company_id` int unsigned DEFAULT NULL,
  `assigned_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_audit_date` datetime DEFAULT NULL,
  `next_audit_date` date DEFAULT NULL,
  `location_id` int DEFAULT NULL,
  `checkin_counter` int NOT NULL DEFAULT '0',
  `checkout_counter` int NOT NULL DEFAULT '0',
  `requests_counter` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `assets_rtd_location_id_index` (`rtd_location_id`),
  KEY `assets_assigned_type_assigned_to_index` (`assigned_type`,`assigned_to`),
  KEY `assets_created_at_index` (`created_at`),
  KEY `assets_deleted_at_status_id_index` (`deleted_at`,`status_id`),
  KEY `assets_deleted_at_model_id_index` (`deleted_at`,`model_id`),
  KEY `assets_deleted_at_assigned_type_assigned_to_index` (`deleted_at`,`assigned_type`,`assigned_to`),
  KEY `assets_deleted_at_supplier_id_index` (`deleted_at`,`supplier_id`),
  KEY `assets_deleted_at_location_id_index` (`deleted_at`,`location_id`),
  KEY `assets_deleted_at_rtd_location_id_index` (`deleted_at`,`rtd_location_id`),
  KEY `assets_deleted_at_asset_tag_index` (`deleted_at`,`asset_tag`),
  KEY `assets_deleted_at_name_index` (`deleted_at`,`name`),
  KEY `assets_serial_index` (`serial`),
  KEY `assets_company_id_index` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
INSERT INTO `assets` VALUES (1,NULL,'A000001',1,'M123456789','2021-02-15',NULL,NULL,11,NULL,NULL,1,'2021-02-23 11:36:33','2021-02-23 11:38:18',1,NULL,2,0,NULL,0,NULL,0,NULL,NULL,NULL,'2021-02-23 11:36:33',NULL,1,'App\\Models\\User',NULL,NULL,1,0,1,0),(2,'Corrugated Tube Cutter','a123',2,'123','2021-03-26',2740.00,'79580038001025644',NULL,NULL,NULL,1,'2021-04-27 08:12:23','2022-05-18 14:32:09',1,NULL,2,0,NULL,0,1,0,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,0,0,0),(3,'Fluke 107 Multimeter','A000101',4,'53660973WS',NULL,NULL,NULL,6,NULL,NULL,1,'2021-07-12 10:13:42','2022-05-18 14:30:33',1,NULL,2,0,NULL,0,1,0,NULL,NULL,NULL,'2022-05-18 15:29:55',NULL,1,'App\\Models\\User',NULL,NULL,NULL,1,3,0),(4,'Test Compressor','A000141',5,'33633','2022-05-20',620.00,'000203626',4,'240v AC, 5.4 amps, max presssure 8 Bar',NULL,55,'2022-06-01 14:40:14','2022-06-01 14:40:14',1,NULL,2,0,NULL,0,4,0,NULL,NULL,NULL,'2022-06-01 15:40:14',NULL,1,'App\\Models\\Location',NULL,NULL,4,0,1,0),(5,'Air receiver','A000142',6,'025','2022-05-16',NULL,'00203626',4,'Fitted to compressor',NULL,55,'2022-06-01 14:43:58','2022-06-01 14:43:58',1,NULL,2,0,NULL,0,4,0,4,NULL,NULL,'2022-06-01 15:43:58',NULL,1,'App\\Models\\Asset',NULL,NULL,4,0,1,0),(6,'CCTV tester with UTC','A000143',8,'N/A',NULL,79.99,NULL,16,NULL,NULL,55,'2022-06-01 15:05:41','2022-06-06 14:20:21',1,NULL,2,0,NULL,0,5,0,1,NULL,NULL,'2022-06-06 15:20:21',NULL,1,'App\\Models\\User',NULL,NULL,NULL,0,1,0),(7,'CCTV Tester with UTC','A000144',8,NULL,NULL,79.99,NULL,49,NULL,NULL,55,'2022-06-06 12:48:15','2022-06-06 14:21:28',1,NULL,2,0,NULL,0,5,0,1,NULL,NULL,'2022-06-06 15:21:27',NULL,1,'App\\Models\\User',NULL,NULL,NULL,0,1,0),(8,'CCTV Tester with UTC','A000145',8,'N/A',NULL,79.99,NULL,13,NULL,NULL,55,'2022-06-06 12:52:46','2022-06-06 14:22:38',1,NULL,2,0,NULL,0,5,0,NULL,NULL,NULL,'2022-06-06 15:22:38',NULL,1,'App\\Models\\User',NULL,NULL,NULL,0,1,0),(9,'CCTV tester with UTC','A000146',8,'N/A',NULL,79.99,NULL,18,NULL,NULL,55,'2022-06-06 12:54:48','2022-06-06 14:23:36',1,NULL,2,0,NULL,0,NULL,0,NULL,NULL,NULL,'2022-06-06 15:23:36',NULL,1,'App\\Models\\User',NULL,NULL,NULL,0,1,0),(10,'CCTV tester with UTC','A000147',8,'N/A',NULL,79.99,NULL,19,NULL,NULL,55,'2022-06-06 12:59:18','2022-06-06 14:24:25',1,NULL,2,0,NULL,0,5,0,NULL,NULL,NULL,'2022-06-06 15:24:25',NULL,1,'App\\Models\\User',NULL,NULL,NULL,0,1,0),(11,'CCTV Tester with UTC','A000148',8,'N/A',NULL,79.99,NULL,6,NULL,NULL,55,'2022-06-06 13:02:50','2022-06-06 13:02:50',1,NULL,2,0,NULL,0,5,0,6,NULL,NULL,'2022-06-06 14:02:50',NULL,1,'App\\Models\\Location',NULL,NULL,6,0,1,0),(12,'CCTV tester with UTC','A000149',8,'N/A',NULL,79.99,NULL,5,NULL,NULL,55,'2022-06-06 13:13:30','2022-06-06 13:44:21',1,NULL,2,0,NULL,0,NULL,0,NULL,NULL,NULL,'2022-06-06 14:13:30',NULL,1,'App\\Models\\Location',NULL,NULL,5,0,1,0),(13,'CCTV tester with UTC','A000150',8,'N/A',NULL,79.99,NULL,54,NULL,NULL,55,'2022-06-06 13:15:34','2022-06-06 14:25:42',1,NULL,2,0,NULL,0,5,0,1,NULL,NULL,'2022-06-06 15:25:42',NULL,1,'App\\Models\\User',NULL,NULL,NULL,0,1,0),(14,'CCTV tester with UTC','A000151',8,'N/A',NULL,79.99,NULL,14,NULL,NULL,55,'2022-06-06 13:44:53','2022-06-06 14:26:48',1,NULL,2,0,NULL,0,5,0,1,NULL,NULL,'2022-06-06 15:26:48',NULL,1,'App\\Models\\User',NULL,NULL,NULL,0,1,0),(15,'CCTV Tester with UTC','A000152',8,'n/a',NULL,79.99,NULL,15,NULL,NULL,55,'2022-06-06 13:47:50','2022-06-06 14:27:31',1,NULL,2,0,NULL,0,NULL,0,1,NULL,NULL,'2022-06-06 15:27:31',NULL,1,'App\\Models\\User',NULL,NULL,NULL,0,1,0),(16,'CCTV tester with UTC','A000180',8,'N/A',NULL,79.99,NULL,11,NULL,NULL,55,'2022-06-06 14:29:14','2022-06-06 14:29:14',1,NULL,2,0,NULL,0,5,0,1,NULL,NULL,'2022-06-06 15:29:14',NULL,NULL,'App\\Models\\User',NULL,NULL,1,0,1,0),(17,'Production Compressor','A00153',5,'32243',NULL,NULL,NULL,2,NULL,NULL,55,'2022-06-06 14:51:54','2022-06-06 14:51:54',1,NULL,2,0,NULL,0,3,0,2,NULL,NULL,'2022-06-06 15:51:54',NULL,1,'App\\Models\\Location',NULL,NULL,2,0,1,0),(18,'receiver for production compressor ','A000154',6,'025',NULL,NULL,NULL,17,NULL,NULL,55,'2022-06-06 14:53:24','2022-06-06 14:53:24',1,NULL,2,0,NULL,0,3,0,2,NULL,NULL,'2022-06-06 15:53:24',NULL,1,'App\\Models\\Asset',NULL,NULL,2,0,1,0),(19,'Injection Mould Tool For 303777','A000155',9,'A000155',NULL,6500.00,NULL,10,NULL,NULL,55,'2022-06-08 13:45:08','2022-06-08 13:45:08',1,NULL,2,0,NULL,0,7,0,10,NULL,NULL,'2022-06-08 14:45:08',NULL,1,'App\\Models\\Location',NULL,NULL,10,0,1,0),(20,'6/12V battery charger','A000156',10,NULL,NULL,NULL,NULL,9,NULL,NULL,55,'2022-06-08 14:42:38','2022-06-08 14:42:38',1,NULL,2,0,NULL,0,NULL,0,9,NULL,NULL,'2022-06-08 15:42:38',NULL,1,'App\\Models\\Location',NULL,NULL,9,0,1,0),(21,NULL,'A000157',10,NULL,NULL,NULL,NULL,9,NULL,NULL,55,'2022-06-08 14:43:30','2022-06-08 14:43:30',1,NULL,2,0,NULL,0,NULL,0,9,NULL,NULL,'2022-06-08 15:43:30',NULL,1,'App\\Models\\Location',NULL,NULL,9,0,1,0),(22,NULL,'A000158',10,NULL,NULL,NULL,NULL,9,NULL,NULL,55,'2022-06-08 14:44:22','2022-06-08 14:44:22',1,NULL,2,0,NULL,0,NULL,0,9,NULL,NULL,'2022-06-08 15:44:22',NULL,1,'App\\Models\\Location',NULL,NULL,9,0,1,0);
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `eula_text` longtext COLLATE utf8mb4_unicode_ci,
  `use_default_eula` tinyint(1) NOT NULL DEFAULT '0',
  `require_acceptance` tinyint(1) NOT NULL DEFAULT '0',
  `category_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'asset',
  `checkin_email` tinyint(1) NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Misc Software','2021-02-23 09:30:46','2021-02-23 09:30:46',NULL,NULL,NULL,0,0,'license',0,NULL),(2,'Tools','2021-02-23 10:38:29','2021-02-23 10:38:29',1,NULL,NULL,0,0,'asset',0,NULL),(3,'FleetPro','2021-03-04 13:25:40','2021-03-04 13:25:40',NULL,NULL,NULL,0,0,'license',0,NULL),(4,'Operational Software','2021-03-04 14:03:20','2021-03-04 14:03:20',NULL,NULL,NULL,0,0,'license',0,NULL),(5,'Machinery','2021-04-27 08:08:33','2021-04-27 08:08:33',NULL,NULL,NULL,0,0,'asset',0,NULL),(6,'VisionPro','2021-10-12 12:12:35','2021-10-12 12:12:35',1,NULL,NULL,0,0,'license',0,NULL),(7,'Injection Mould Tooling','2022-06-08 13:38:26','2022-06-08 13:38:26',NULL,NULL,NULL,0,0,'component',0,NULL),(8,'Battery Charger','2022-06-08 14:39:42','2022-06-08 14:39:42',NULL,NULL,NULL,0,0,'component',0,NULL);
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `checkout_acceptances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `checkout_acceptances` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `checkoutable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `checkoutable_id` bigint unsigned NOT NULL,
  `assigned_to_id` int DEFAULT NULL,
  `signature_filename` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `accepted_at` timestamp NULL DEFAULT NULL,
  `declined_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `stored_eula` text COLLATE utf8mb4_unicode_ci,
  `stored_eula_file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checkout_acceptances_checkoutable_type_checkoutable_id_index` (`checkoutable_type`,`checkoutable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `checkout_acceptances` WRITE;
/*!40000 ALTER TABLE `checkout_acceptances` DISABLE KEYS */;
/*!40000 ALTER TABLE `checkout_acceptances` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `checkout_requests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `checkout_requests` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `requestable_id` int NOT NULL,
  `requestable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `canceled_at` datetime DEFAULT NULL,
  `fulfilled_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checkout_requests_user_id_requestable_id_requestable_type` (`user_id`,`requestable_id`,`requestable_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `checkout_requests` WRITE;
/*!40000 ALTER TABLE `checkout_requests` DISABLE KEYS */;
/*!40000 ALTER TABLE `checkout_requests` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `companies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `companies` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `companies_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `companies` WRITE;
/*!40000 ALTER TABLE `companies` DISABLE KEYS */;
INSERT INTO `companies` VALUES (1,'TVG','2021-02-23 10:17:44','2021-02-23 10:17:44','company-image-OjW0WGBBMx.png');
/*!40000 ALTER TABLE `companies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `components`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `components` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category_id` int DEFAULT NULL,
  `location_id` int DEFAULT NULL,
  `company_id` int DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `qty` int NOT NULL DEFAULT '1',
  `order_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `purchase_cost` decimal(20,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `min_amt` int DEFAULT NULL,
  `serial` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `components_company_id_index` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `components` WRITE;
/*!40000 ALTER TABLE `components` DISABLE KEYS */;
INSERT INTO `components` VALUES (1,'MP7423',8,9,1,55,1,NULL,NULL,NULL,'2022-06-08 14:40:51','2022-06-08 14:40:51',NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `components` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `components_assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `components_assets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `assigned_qty` int DEFAULT '1',
  `component_id` int DEFAULT NULL,
  `asset_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `components_assets` WRITE;
/*!40000 ALTER TABLE `components_assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `components_assets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `consumables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumables` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category_id` int DEFAULT NULL,
  `location_id` int DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `qty` int NOT NULL DEFAULT '0',
  `requestable` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `purchase_cost` decimal(20,2) DEFAULT NULL,
  `order_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_id` int unsigned DEFAULT NULL,
  `min_amt` int DEFAULT NULL,
  `model_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `manufacturer_id` int DEFAULT NULL,
  `item_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `consumables_company_id_index` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `consumables` WRITE;
/*!40000 ALTER TABLE `consumables` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `consumables_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumables_users` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `consumable_id` int DEFAULT NULL,
  `assigned_to` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `consumables_users` WRITE;
/*!40000 ALTER TABLE `consumables_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumables_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `custom_field_custom_fieldset`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `custom_field_custom_fieldset` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` int NOT NULL,
  `custom_fieldset_id` int NOT NULL,
  `order` int NOT NULL,
  `required` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `custom_field_custom_fieldset` WRITE;
/*!40000 ALTER TABLE `custom_field_custom_fieldset` DISABLE KEYS */;
INSERT INTO `custom_field_custom_fieldset` VALUES (1,1,1,1,0);
/*!40000 ALTER TABLE `custom_field_custom_fieldset` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `custom_fields` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `format` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `field_values` text COLLATE utf8mb4_unicode_ci,
  `field_encrypted` tinyint(1) NOT NULL DEFAULT '0',
  `db_column` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `help_text` text COLLATE utf8mb4_unicode_ci,
  `show_in_email` tinyint(1) NOT NULL DEFAULT '0',
  `is_unique` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `custom_fields` WRITE;
/*!40000 ALTER TABLE `custom_fields` DISABLE KEYS */;
INSERT INTO `custom_fields` VALUES (1,'MAC Address','regex:/^[a-fA-F0-9]{2}:[a-fA-F0-9]{2}:[a-fA-F0-9]{2}:[a-fA-F0-9]{2}:[a-fA-F0-9]{2}:[a-fA-F0-9]{2}$/','text',NULL,'2021-02-23 09:30:40',NULL,NULL,0,'_snipeit_mac_address_1',NULL,0,0);
/*!40000 ALTER TABLE `custom_fields` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `custom_fieldsets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `custom_fieldsets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `custom_fieldsets` WRITE;
/*!40000 ALTER TABLE `custom_fieldsets` DISABLE KEYS */;
INSERT INTO `custom_fieldsets` VALUES (1,'Asset with MAC Address',NULL,NULL,NULL);
/*!40000 ALTER TABLE `custom_fieldsets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `departments` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int NOT NULL,
  `company_id` int DEFAULT NULL,
  `location_id` int DEFAULT NULL,
  `manager_id` int DEFAULT NULL,
  `notes` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `departments_company_id_index` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `departments` WRITE;
/*!40000 ALTER TABLE `departments` DISABLE KEYS */;
INSERT INTO `departments` VALUES (1,'Fleet Support',1,1,1,5,NULL,'2021-02-23 10:37:28','2021-02-23 10:37:28',NULL,NULL),(2,'Manufacturing',1,1,2,42,NULL,'2021-04-06 17:14:12','2021-04-06 17:14:12',NULL,NULL),(3,'Technical Division',1,1,4,6,NULL,'2022-05-18 14:12:35','2022-05-18 14:12:35',NULL,NULL),(4,'R&D',1,1,5,53,NULL,'2022-05-18 14:12:47','2022-05-18 14:12:47',NULL,NULL),(5,'Engineering',1,1,6,55,NULL,'2022-05-18 14:12:58','2022-05-18 14:12:58',NULL,NULL);
/*!40000 ALTER TABLE `departments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `depreciations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depreciations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `months` int NOT NULL,
  `depreciation_min` decimal(8,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `depreciations` WRITE;
/*!40000 ALTER TABLE `depreciations` DISABLE KEYS */;
/*!40000 ALTER TABLE `depreciations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `imports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `imports` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_path` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `filesize` int NOT NULL,
  `import_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `header_row` text COLLATE utf8mb4_unicode_ci,
  `first_row` text COLLATE utf8mb4_unicode_ci,
  `field_map` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `imports` WRITE;
/*!40000 ALTER TABLE `imports` DISABLE KEYS */;
/*!40000 ALTER TABLE `imports` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `kits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `kits` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `kits` WRITE;
/*!40000 ALTER TABLE `kits` DISABLE KEYS */;
/*!40000 ALTER TABLE `kits` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `kits_accessories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `kits_accessories` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `kit_id` int DEFAULT NULL,
  `accessory_id` int DEFAULT NULL,
  `quantity` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `kits_accessories` WRITE;
/*!40000 ALTER TABLE `kits_accessories` DISABLE KEYS */;
/*!40000 ALTER TABLE `kits_accessories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `kits_consumables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `kits_consumables` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `kit_id` int DEFAULT NULL,
  `consumable_id` int DEFAULT NULL,
  `quantity` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `kits_consumables` WRITE;
/*!40000 ALTER TABLE `kits_consumables` DISABLE KEYS */;
/*!40000 ALTER TABLE `kits_consumables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `kits_licenses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `kits_licenses` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `kit_id` int DEFAULT NULL,
  `license_id` int DEFAULT NULL,
  `quantity` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `kits_licenses` WRITE;
/*!40000 ALTER TABLE `kits_licenses` DISABLE KEYS */;
/*!40000 ALTER TABLE `kits_licenses` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `kits_models`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `kits_models` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `kit_id` int DEFAULT NULL,
  `model_id` int DEFAULT NULL,
  `quantity` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `kits_models` WRITE;
/*!40000 ALTER TABLE `kits_models` DISABLE KEYS */;
/*!40000 ALTER TABLE `kits_models` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `license_seats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `license_seats` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `license_id` int DEFAULT NULL,
  `assigned_to` int DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `user_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `asset_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `license_seats_license_id_index` (`license_id`)
) ENGINE=InnoDB AUTO_INCREMENT=118 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `license_seats` WRITE;
/*!40000 ALTER TABLE `license_seats` DISABLE KEYS */;
INSERT INTO `license_seats` VALUES (1,1,48,NULL,1,'2021-03-04 13:26:12','2021-10-12 12:14:57',NULL,NULL),(2,1,5,NULL,1,'2021-03-04 13:26:12','2021-03-04 13:30:24',NULL,NULL),(3,1,51,NULL,1,'2021-03-04 13:26:12','2022-07-06 12:48:28',NULL,NULL),(4,1,48,NULL,1,'2021-03-04 13:26:12','2022-07-06 12:48:45',NULL,NULL),(5,1,55,NULL,1,'2021-03-04 13:26:12','2022-07-06 12:49:19',NULL,NULL),(6,2,48,NULL,1,'2021-03-04 14:01:54','2021-10-12 12:14:09',NULL,NULL),(7,2,NULL,NULL,NULL,'2021-03-04 14:01:54','2021-03-04 14:01:54',NULL,NULL),(8,2,NULL,NULL,NULL,'2021-03-04 14:01:54','2021-03-04 14:01:54',NULL,NULL),(9,2,NULL,NULL,NULL,'2021-03-04 14:01:54','2021-03-04 14:01:54',NULL,NULL),(10,2,NULL,NULL,NULL,'2021-03-04 14:01:54','2021-03-04 14:01:54',NULL,NULL),(11,3,NULL,NULL,1,'2021-03-04 14:03:36','2021-10-07 12:07:15',NULL,NULL),(12,3,NULL,NULL,NULL,'2021-03-04 14:03:36','2021-03-04 14:03:36',NULL,NULL),(13,3,NULL,NULL,NULL,'2021-03-04 14:03:36','2021-03-04 14:03:36',NULL,NULL),(14,3,NULL,NULL,NULL,'2021-03-04 14:03:36','2021-03-04 14:03:36',NULL,NULL),(15,3,NULL,NULL,NULL,'2021-03-04 14:03:36','2021-03-04 14:03:36',NULL,NULL),(16,4,NULL,NULL,1,'2021-03-04 14:05:01','2021-10-07 12:07:15',NULL,NULL),(17,4,NULL,NULL,NULL,'2021-03-04 14:05:01','2021-03-04 14:05:01',NULL,NULL),(18,4,NULL,NULL,NULL,'2021-03-04 14:05:01','2021-03-04 14:05:01',NULL,NULL),(19,4,NULL,NULL,NULL,'2021-03-04 14:05:01','2021-03-04 14:05:01',NULL,NULL),(20,4,NULL,NULL,NULL,'2021-03-04 14:05:01','2021-03-04 14:05:01',NULL,NULL),(21,4,NULL,NULL,NULL,'2021-03-04 14:05:01','2021-03-04 14:05:01',NULL,NULL),(22,4,NULL,NULL,NULL,'2021-03-04 14:05:01','2021-03-04 14:05:01',NULL,NULL),(23,4,NULL,NULL,NULL,'2021-03-04 14:05:01','2021-03-04 14:05:01',NULL,NULL),(24,4,NULL,NULL,NULL,'2021-03-04 14:05:01','2021-03-04 14:05:01',NULL,NULL),(25,4,NULL,NULL,NULL,'2021-03-04 14:05:01','2021-03-04 14:05:01',NULL,NULL),(26,4,NULL,NULL,NULL,'2021-03-04 14:05:01','2021-03-04 14:05:01',NULL,NULL),(27,4,NULL,NULL,NULL,'2021-03-04 14:05:01','2021-03-04 14:05:01',NULL,NULL),(28,4,NULL,NULL,NULL,'2021-03-04 14:05:01','2021-03-04 14:05:01',NULL,NULL),(29,4,NULL,NULL,NULL,'2021-03-04 14:05:01','2021-03-04 14:05:01',NULL,NULL),(30,4,NULL,NULL,NULL,'2021-03-04 14:05:01','2021-03-04 14:05:01',NULL,NULL),(31,4,NULL,NULL,NULL,'2021-03-04 14:05:01','2021-03-04 14:05:01',NULL,NULL),(32,4,NULL,NULL,NULL,'2021-03-04 14:05:01','2021-03-04 14:05:01',NULL,NULL),(33,4,NULL,NULL,NULL,'2021-03-04 14:05:01','2021-03-04 14:05:01',NULL,NULL),(34,4,NULL,NULL,NULL,'2021-03-04 14:05:01','2021-03-04 14:05:01',NULL,NULL),(35,4,NULL,NULL,NULL,'2021-03-04 14:05:01','2021-03-04 14:05:01',NULL,NULL),(36,5,NULL,NULL,1,'2021-03-04 14:20:00','2022-05-18 14:13:46',NULL,NULL),(37,5,51,NULL,1,'2021-03-04 14:20:00','2021-10-12 12:14:34',NULL,NULL),(38,5,48,NULL,1,'2021-03-04 14:20:00','2021-10-12 12:14:42',NULL,NULL),(39,5,NULL,NULL,NULL,'2021-03-04 14:20:00','2021-03-04 14:20:00',NULL,NULL),(40,5,NULL,NULL,NULL,'2021-03-04 14:20:00','2021-03-04 14:20:00',NULL,NULL),(41,5,NULL,NULL,NULL,'2021-03-04 14:20:00','2021-03-04 14:20:00',NULL,NULL),(42,5,NULL,NULL,NULL,'2021-03-04 14:20:00','2021-03-04 14:20:00',NULL,NULL),(43,5,NULL,NULL,NULL,'2021-03-04 14:20:00','2021-03-04 14:20:00',NULL,NULL),(44,5,NULL,NULL,NULL,'2021-03-04 14:20:00','2021-03-04 14:20:00',NULL,NULL),(45,5,NULL,NULL,NULL,'2021-03-04 14:20:00','2021-03-04 14:20:00',NULL,NULL),(46,5,NULL,NULL,NULL,'2021-03-04 14:20:00','2021-03-04 14:20:00',NULL,NULL),(47,5,NULL,NULL,NULL,'2021-03-04 14:20:00','2021-03-04 14:20:00',NULL,NULL),(48,5,NULL,NULL,NULL,'2021-03-04 14:20:00','2021-03-04 14:20:00',NULL,NULL),(49,5,NULL,NULL,NULL,'2021-03-04 14:20:00','2021-03-04 14:20:00',NULL,NULL),(50,5,NULL,NULL,NULL,'2021-03-04 14:20:00','2021-03-04 14:20:00',NULL,NULL),(51,5,NULL,NULL,NULL,'2021-03-04 14:20:00','2021-03-04 14:20:00',NULL,NULL),(52,5,NULL,NULL,NULL,'2021-03-04 14:20:00','2021-03-04 14:20:00',NULL,NULL),(53,5,NULL,NULL,NULL,'2021-03-04 14:20:00','2021-03-04 14:20:00',NULL,NULL),(54,5,NULL,NULL,NULL,'2021-03-04 14:20:00','2021-03-04 14:20:00',NULL,NULL),(55,5,NULL,NULL,NULL,'2021-03-04 14:20:00','2021-03-04 14:20:00',NULL,NULL),(56,6,48,NULL,1,'2021-03-05 09:08:48','2021-10-12 12:13:55',NULL,NULL),(57,6,NULL,NULL,NULL,'2021-03-05 09:08:48','2021-03-05 09:08:48',NULL,NULL),(58,6,NULL,NULL,NULL,'2021-03-05 09:08:48','2021-03-05 09:08:48',NULL,NULL),(59,6,NULL,NULL,NULL,'2021-03-05 09:08:48','2021-03-05 09:08:48',NULL,NULL),(60,6,NULL,NULL,NULL,'2021-03-05 09:08:48','2021-03-05 09:08:48',NULL,NULL),(61,7,48,NULL,1,'2021-10-12 12:12:16','2021-10-12 12:13:33',NULL,NULL),(62,7,NULL,NULL,1,'2021-10-12 12:12:16','2022-05-18 14:13:52',NULL,NULL),(63,7,NULL,NULL,NULL,'2021-10-12 12:12:16','2021-10-12 12:12:16',NULL,NULL),(64,7,NULL,NULL,NULL,'2021-10-12 12:12:16','2021-10-12 12:12:16',NULL,NULL),(65,7,NULL,NULL,NULL,'2021-10-12 12:12:16','2021-10-12 12:12:16',NULL,NULL),(66,8,48,NULL,1,'2021-10-14 09:06:07','2021-10-14 09:06:16',NULL,NULL),(67,8,NULL,NULL,1,'2021-10-14 09:06:07','2022-05-18 14:13:55',NULL,NULL),(68,8,51,NULL,1,'2021-10-14 09:06:07','2021-10-14 09:10:56',NULL,NULL),(69,8,31,NULL,1,'2021-10-14 09:06:07','2021-10-14 09:11:15',NULL,NULL),(70,8,24,NULL,1,'2021-10-14 09:06:07','2021-10-14 09:11:22',NULL,NULL),(71,8,NULL,NULL,NULL,'2021-10-14 09:06:07','2021-10-14 09:06:07',NULL,NULL),(72,8,NULL,NULL,NULL,'2021-10-14 09:06:07','2021-10-14 09:06:07',NULL,NULL),(73,8,NULL,NULL,NULL,'2021-10-14 09:06:07','2021-10-14 09:06:07',NULL,NULL),(74,8,NULL,NULL,NULL,'2021-10-14 09:06:07','2021-10-14 09:06:07',NULL,NULL),(75,8,NULL,NULL,NULL,'2021-10-14 09:06:07','2021-10-14 09:06:07',NULL,NULL),(76,8,NULL,NULL,NULL,'2021-10-14 09:06:07','2021-10-14 09:06:07',NULL,NULL),(77,8,NULL,NULL,NULL,'2021-10-14 09:06:07','2021-10-14 09:06:07',NULL,NULL),(78,8,NULL,NULL,NULL,'2021-10-14 09:06:07','2021-10-14 09:06:07',NULL,NULL),(79,8,NULL,NULL,NULL,'2021-10-14 09:06:07','2021-10-14 09:06:07',NULL,NULL),(80,8,NULL,NULL,NULL,'2021-10-14 09:06:07','2021-10-14 09:06:07',NULL,NULL),(81,8,NULL,NULL,NULL,'2021-10-14 09:06:07','2021-10-14 09:06:07',NULL,NULL),(82,8,NULL,NULL,NULL,'2021-10-14 09:06:07','2021-10-14 09:06:07',NULL,NULL),(83,8,NULL,NULL,NULL,'2021-10-14 09:06:07','2021-10-14 09:06:07',NULL,NULL),(84,8,NULL,NULL,NULL,'2021-10-14 09:06:07','2021-10-14 09:06:07',NULL,NULL),(85,8,NULL,NULL,NULL,'2021-10-14 09:06:07','2021-10-14 09:06:07',NULL,NULL),(86,8,NULL,NULL,NULL,'2021-10-14 09:06:07','2021-10-14 09:06:07',NULL,NULL),(87,8,NULL,NULL,NULL,'2021-10-14 09:06:07','2021-10-14 09:06:07',NULL,NULL),(88,9,NULL,NULL,1,'2021-10-14 10:39:36','2022-05-18 14:13:58',NULL,NULL),(89,9,NULL,NULL,NULL,'2021-10-14 10:39:36','2021-10-14 10:39:36',NULL,NULL),(90,9,NULL,NULL,NULL,'2021-10-14 10:39:36','2021-10-14 10:39:36',NULL,NULL),(91,9,NULL,NULL,NULL,'2021-10-14 10:39:36','2021-10-14 10:39:36',NULL,NULL),(92,9,NULL,NULL,NULL,'2021-10-14 10:39:36','2021-10-14 10:39:36',NULL,NULL),(93,9,NULL,NULL,NULL,'2021-10-14 10:39:36','2021-10-14 10:39:36',NULL,NULL),(94,9,NULL,NULL,NULL,'2021-10-14 10:39:36','2021-10-14 10:39:36',NULL,NULL),(95,9,NULL,NULL,NULL,'2021-10-14 10:39:36','2021-10-14 10:39:36',NULL,NULL),(96,10,NULL,NULL,NULL,'2021-10-14 10:40:31','2021-10-14 10:40:31',NULL,NULL),(97,10,NULL,NULL,NULL,'2021-10-14 10:40:31','2021-10-14 10:40:31',NULL,NULL),(98,10,NULL,NULL,NULL,'2021-10-14 10:40:31','2021-10-14 10:40:31',NULL,NULL),(99,10,NULL,NULL,NULL,'2021-10-14 10:40:31','2021-10-14 10:40:31',NULL,NULL),(100,10,NULL,NULL,NULL,'2021-10-14 10:40:31','2021-10-14 10:40:31',NULL,NULL),(101,11,55,NULL,1,'2022-07-06 12:46:36','2022-07-06 12:47:31',NULL,NULL),(102,11,48,NULL,1,'2022-07-06 12:46:36','2022-07-06 12:47:42',NULL,NULL),(103,11,6,NULL,1,'2022-07-06 12:46:36','2022-07-06 12:47:52',NULL,NULL),(104,11,NULL,NULL,1,'2022-07-06 12:46:36','2022-07-06 12:46:36',NULL,NULL),(105,11,NULL,NULL,1,'2022-07-06 12:46:36','2022-07-06 12:46:36',NULL,NULL),(106,11,NULL,NULL,1,'2022-07-06 12:46:36','2022-07-06 12:46:36',NULL,NULL),(107,11,NULL,NULL,1,'2022-07-06 12:46:36','2022-07-06 12:46:36',NULL,NULL),(108,11,NULL,NULL,1,'2022-07-06 12:46:36','2022-07-06 12:46:36',NULL,NULL),(109,11,NULL,NULL,1,'2022-07-06 12:46:36','2022-07-06 12:46:36',NULL,NULL),(110,11,NULL,NULL,1,'2022-07-06 12:46:36','2022-07-06 12:46:36',NULL,NULL),(111,11,NULL,NULL,1,'2022-07-06 12:46:36','2022-07-06 12:46:36',NULL,NULL),(112,11,NULL,NULL,1,'2022-07-06 12:46:36','2022-07-06 12:46:36',NULL,NULL),(113,1,NULL,NULL,1,'2022-07-06 12:49:09','2022-07-06 12:49:09',NULL,NULL),(114,1,NULL,NULL,1,'2022-07-06 12:49:09','2022-07-06 12:49:09',NULL,NULL),(115,1,NULL,NULL,1,'2022-07-06 12:49:09','2022-07-06 12:49:09',NULL,NULL),(116,1,NULL,NULL,1,'2022-07-06 12:49:09','2022-07-06 12:49:09',NULL,NULL),(117,1,NULL,NULL,1,'2022-07-06 12:49:09','2022-07-06 12:49:09',NULL,NULL);
/*!40000 ALTER TABLE `license_seats` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `licenses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `licenses` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `serial` text COLLATE utf8mb4_unicode_ci,
  `purchase_date` date DEFAULT NULL,
  `purchase_cost` decimal(20,2) DEFAULT NULL,
  `order_number` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `seats` int NOT NULL DEFAULT '1',
  `notes` text COLLATE utf8mb4_unicode_ci,
  `user_id` int DEFAULT NULL,
  `depreciation_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `license_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `license_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `depreciate` tinyint(1) DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `expiration_date` date DEFAULT NULL,
  `purchase_order` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `termination_date` date DEFAULT NULL,
  `maintained` tinyint(1) DEFAULT NULL,
  `reassignable` tinyint(1) NOT NULL DEFAULT '1',
  `company_id` int unsigned DEFAULT NULL,
  `manufacturer_id` int DEFAULT NULL,
  `category_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `licenses_company_id_index` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `licenses` WRITE;
/*!40000 ALTER TABLE `licenses` DISABLE KEYS */;
INSERT INTO `licenses` VALUES (1,'FleetPro Admin','N/A',NULL,NULL,NULL,10,NULL,1,NULL,'2021-03-04 13:26:12','2022-07-06 12:49:09',NULL,'N/A',NULL,NULL,1,NULL,NULL,NULL,0,1,1,3,3),(2,'TachoPro Admin','N/A',NULL,NULL,NULL,5,NULL,1,NULL,'2021-03-04 14:01:54','2021-03-04 14:01:54',NULL,'N/A',NULL,NULL,1,NULL,NULL,NULL,0,1,1,3,3),(3,'Moodle','N/A',NULL,NULL,NULL,5,NULL,1,NULL,'2021-03-04 14:03:36','2021-03-04 14:03:36',NULL,'N/A',NULL,NULL,1,NULL,NULL,NULL,0,1,1,3,4),(4,'Teamwork','N/A',NULL,NULL,NULL,20,NULL,1,NULL,'2021-03-04 14:05:01','2021-03-04 14:05:01',NULL,'N/A',NULL,NULL,1,NULL,NULL,NULL,0,1,1,3,4),(5,'Freshdesk','N/A',NULL,NULL,NULL,20,NULL,1,NULL,'2021-03-04 14:20:00','2021-03-04 14:20:00',NULL,'N/A',NULL,NULL,1,NULL,NULL,NULL,0,1,1,3,4),(6,'Teltonika FOTA','N/A',NULL,NULL,NULL,5,NULL,1,NULL,'2021-03-05 09:08:48','2021-03-05 09:08:48',NULL,'N/A',NULL,NULL,2,NULL,NULL,NULL,0,1,1,4,3),(7,'VisionPro Admin',NULL,NULL,NULL,NULL,5,NULL,1,NULL,'2021-10-12 12:12:16','2021-10-12 12:12:56',NULL,'N/A',NULL,NULL,1,NULL,NULL,NULL,0,1,1,3,6),(8,'Dropbox',NULL,NULL,NULL,NULL,22,NULL,1,NULL,'2021-10-14 09:06:07','2021-10-14 09:06:07',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,1,1,NULL,4),(9,'Cognito Forms',NULL,NULL,NULL,NULL,8,NULL,1,NULL,'2021-10-14 10:39:36','2021-10-14 10:39:36',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,1,NULL,NULL,4),(10,'Jot Forms',NULL,NULL,NULL,NULL,5,NULL,1,NULL,'2021-10-14 10:40:31','2021-10-14 10:40:31',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,1,NULL,NULL,4),(11,'Freshping',NULL,NULL,NULL,NULL,12,'https://tvg.freshping.io/',1,NULL,'2022-07-06 12:46:36','2022-07-06 12:46:36',NULL,'N/A',NULL,NULL,1,NULL,NULL,NULL,0,1,1,3,4);
/*!40000 ALTER TABLE `licenses` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `locations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `currency` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ldap_ou` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `manager_id` int DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `locations` WRITE;
/*!40000 ALTER TABLE `locations` DISABLE KEYS */;
INSERT INTO `locations` VALUES (1,'Field Technician',NULL,NULL,'UK','2021-02-23 10:36:58','2021-02-23 10:36:58',1,NULL,NULL,NULL,NULL,NULL,'GBP',NULL,5,NULL),(2,'Manufacturing',NULL,NULL,'UK','2021-04-06 17:13:22','2021-04-06 17:13:22',1,NULL,NULL,NULL,NULL,NULL,'GBP',NULL,42,NULL),(3,'Lockshop',NULL,NULL,'UK','2021-04-06 17:13:39','2021-04-06 17:13:39',1,NULL,NULL,NULL,NULL,NULL,'GBP',NULL,42,NULL),(4,'Technical Division','Catterick Garrison','North Yorkshire','UK','2021-07-12 11:27:58','2022-05-18 12:19:51',NULL,'1 Target','Chartermark Way','DL9 4QJ',NULL,NULL,'GBP',NULL,6,NULL),(5,'R&D','Catterick Garrison','North Yorkshire','UK','2022-05-18 12:20:25','2022-05-18 12:20:25',1,'1 Target','Chartermark Way','DL9 4QJ',NULL,4,'GBP',NULL,53,NULL),(6,'Engineering','Catterick Garrison','North Yorkshire','UK','2022-05-18 12:20:45','2022-05-18 12:20:45',1,'1 Target','Chartermark Way','DL9 4QJ',NULL,4,'GBP',NULL,55,NULL),(7,'Test Lab','Catterick Garrison','North Yorkshire','UK','2022-05-18 14:42:05','2022-05-18 14:42:05',1,'1 Target','Chartermark Way','DL9 4QJ',NULL,4,'GBP',NULL,NULL,NULL),(8,'TD Warehouse','Catterick Garrison','North Yorkshire','UK','2022-05-18 14:42:50','2022-05-18 14:42:50',1,'1 Target','Chartermark Way','DL9 4QJ',NULL,4,'GBP',NULL,NULL,NULL),(9,'Vehicle Bay','Catterick Garrison','North Yorkshire','UK','2022-05-18 14:43:24','2022-05-18 14:43:24',1,'1 Target','Chartermark Way','DL9 4QJ',NULL,6,'GBP',NULL,NULL,NULL),(10,'IVM Limited','DL120UT',NULL,'UK','2022-06-08 13:44:22','2022-06-08 13:44:22',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `login_attempts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `login_attempts` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remote_ip` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `successful` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `login_attempts` WRITE;
/*!40000 ALTER TABLE `login_attempts` DISABLE KEYS */;
INSERT INTO `login_attempts` VALUES (1,'mf','185.13.244.170','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/88.0.4324.150 Safari/537.36 Edg/88.0.705.63',1,'2021-02-23 09:35:43',NULL),(2,'mfa','185.13.244.170','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/88.0.4324.182 Safari/537.36 Edg/88.0.705.74',1,'2021-02-23 14:40:31',NULL),(3,'mfa','185.13.244.170','Mozilla/5.0 (Linux; Android 11; SM-N970F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36 EdgA/46.01.4.5140',1,'2021-02-26 11:25:33',NULL),(4,'mfa','185.13.244.170','Mozilla/5.0 (Linux; Android 11; SM-N970F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.116 Mobile Safari/537.36 EdgA/46.03.4.5155',1,'2021-04-06 14:55:36',NULL),(5,'mfa','185.13.244.170','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/88.0.4324.182 Safari/537.36 Edg/88.0.705.74',1,'2021-04-06 17:10:44',NULL),(6,'mfa','185.13.244.170','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.128 Safari/537.36 Edg/89.0.774.77',1,'2021-04-27 08:05:50',NULL),(7,'mfa','185.13.244.170','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.128 Safari/537.36 Edg/89.0.774.77',1,'2021-05-14 14:07:30',NULL),(8,'Tom.Askew','185.13.244.170','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.93 Safari/537.36 Edg/90.0.818.56',1,'2021-05-14 14:09:21',NULL),(9,'mf','185.13.244.170','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36 Edg/91.0.864.59',1,'2021-07-02 07:00:51',NULL),(10,'mf','185.13.244.170','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36 Edg/91.0.864.59',1,'2021-07-12 08:16:14',NULL),(12,'mfa','185.13.244.170','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36 Edg/91.0.864.59',1,'2021-07-12 09:43:44',NULL),(13,'mf','185.13.244.170','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/93.0.4577.63 Safari/537.36 Edg/93.0.961.47',1,'2021-09-21 11:47:05',NULL),(14,'tvga','185.13.244.170','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/93.0.4577.63 Safari/537.36 Edg/93.0.961.47',1,'2021-09-21 11:47:55',NULL),(15,'mfa','185.13.244.170','Mozilla/5.0 (Linux; Android 11; SM-G991B) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/93.0.4577.82 Mobile Safari/537.36 EdgA/93.0.961.69',1,'2021-10-07 12:30:47',NULL),(22,'mf','185.13.244.170','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/101.0.4951.54 Safari/537.36 Edg/101.0.1210.39',1,'2022-05-18 12:13:34',NULL),(23,'mfa','185.13.244.170','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/101.0.4951.54 Safari/537.36 Edg/101.0.1210.39',1,'2022-05-18 12:13:50',NULL),(24,'mfa','185.13.244.170','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/101.0.4951.54 Safari/537.36 Edg/101.0.1210.39',1,'2022-05-18 14:26:06',NULL),(35,'Simon.Giles','185.13.244.170','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/101.0.4951.64 Safari/537.36 Edg/101.0.1210.53',1,'2022-05-27 08:32:31',NULL),(36,'Matthew.Carrick','185.13.244.170','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/101.0.4951.64 Safari/537.36 Edg/101.0.1210.53',1,'2022-05-27 10:04:47',NULL),(37,'mf','185.13.244.170','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.53 Safari/537.36 Edg/103.0.1264.37',1,'2022-07-01 06:36:02',NULL),(38,'tvga','185.13.244.170','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.53 Safari/537.36 Edg/103.0.1264.37',0,'2022-07-01 06:36:20',NULL),(39,'mfa','185.13.244.170','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.53 Safari/537.36 Edg/103.0.1264.37',1,'2022-07-01 06:36:28',NULL);
/*!40000 ALTER TABLE `login_attempts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `manufacturers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `manufacturers` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `support_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `support_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `support_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `manufacturers` WRITE;
/*!40000 ALTER TABLE `manufacturers` DISABLE KEYS */;
INSERT INTO `manufacturers` VALUES (1,'Milwaukee','2021-02-23 10:42:08','2021-02-23 10:42:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'De-Walt','2021-02-23 10:42:14','2021-02-23 10:42:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'TVG','2021-03-04 13:25:50','2021-03-04 13:25:50',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,'Teltonika','2021-03-05 09:08:31','2021-03-05 09:08:31',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,'Fluke','2021-07-12 09:45:32','2021-07-12 09:45:32',1,NULL,'https://www.fluke.com/en-gb',NULL,NULL,NULL,'manufacturer-image-NlOtxWG5ud.png'),(6,'Bambi Air Ltd','2022-05-18 14:33:01','2022-05-18 14:33:01',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `manufacturers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=331 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2012_12_06_225921_migration_cartalyst_sentry_install_users',1),(2,'2012_12_06_225929_migration_cartalyst_sentry_install_groups',1),(3,'2012_12_06_225945_migration_cartalyst_sentry_install_users_groups_pivot',1),(4,'2012_12_06_225988_migration_cartalyst_sentry_install_throttle',1),(5,'2013_03_23_193214_update_users_table',1),(6,'2013_11_13_075318_create_models_table',1),(7,'2013_11_13_075335_create_categories_table',1),(8,'2013_11_13_075347_create_manufacturers_table',1),(9,'2013_11_15_015858_add_user_id_to_categories',1),(10,'2013_11_15_112701_add_user_id_to_manufacturers',1),(11,'2013_11_15_190327_create_assets_table',1),(12,'2013_11_15_190357_create_licenses_table',1),(13,'2013_11_15_201848_add_license_name_to_licenses',1),(14,'2013_11_16_040323_create_depreciations_table',1),(15,'2013_11_16_042851_add_depreciation_id_to_models',1),(16,'2013_11_16_084923_add_user_id_to_models',1),(17,'2013_11_16_103258_create_locations_table',1),(18,'2013_11_16_103336_add_location_id_to_assets',1),(19,'2013_11_16_103407_add_checkedout_to_to_assets',1),(20,'2013_11_16_103425_create_history_table',1),(21,'2013_11_17_054359_drop_licenses_table',1),(22,'2013_11_17_054526_add_physical_to_assets',1),(23,'2013_11_17_055126_create_settings_table',1),(24,'2013_11_17_062634_add_license_to_assets',1),(25,'2013_11_18_134332_add_contacts_to_users',1),(26,'2013_11_18_142847_add_info_to_locations',1),(27,'2013_11_18_152942_remove_location_id_from_asset',1),(28,'2013_11_18_164423_set_nullvalues_for_user',1),(29,'2013_11_19_013337_create_asset_logs_table',1),(30,'2013_11_19_061409_edit_added_on_asset_logs_table',1),(31,'2013_11_19_062250_edit_location_id_asset_logs_table',1),(32,'2013_11_20_055822_add_soft_delete_on_assets',1),(33,'2013_11_20_121404_add_soft_delete_on_locations',1),(34,'2013_11_20_123137_add_soft_delete_on_manufacturers',1),(35,'2013_11_20_123725_add_soft_delete_on_categories',1),(36,'2013_11_20_130248_create_status_labels',1),(37,'2013_11_20_130830_add_status_id_on_assets_table',1),(38,'2013_11_20_131544_add_status_type_on_status_labels',1),(39,'2013_11_20_134103_add_archived_to_assets',1),(40,'2013_11_21_002321_add_uploads_table',1),(41,'2013_11_21_024531_remove_deployable_boolean_from_status_labels',1),(42,'2013_11_22_075308_add_option_label_to_settings_table',1),(43,'2013_11_22_213400_edits_to_settings_table',1),(44,'2013_11_25_013244_create_licenses_table',1),(45,'2013_11_25_031458_create_license_seats_table',1),(46,'2013_11_25_032022_add_type_to_actionlog_table',1),(47,'2013_11_25_033008_delete_bad_licenses_table',1),(48,'2013_11_25_033131_create_new_licenses_table',1),(49,'2013_11_25_033534_add_licensed_to_licenses_table',1),(50,'2013_11_25_101308_add_warrantee_to_assets_table',1),(51,'2013_11_25_104343_alter_warranty_column_on_assets',1),(52,'2013_11_25_150450_drop_parent_from_categories',1),(53,'2013_11_25_151920_add_depreciate_to_assets',1),(54,'2013_11_25_152903_add_depreciate_to_licenses_table',1),(55,'2013_11_26_211820_drop_license_from_assets_table',1),(56,'2013_11_27_062510_add_note_to_asset_logs_table',1),(57,'2013_12_01_113426_add_filename_to_asset_log',1),(58,'2013_12_06_094618_add_nullable_to_licenses_table',1),(59,'2013_12_10_084038_add_eol_on_models_table',1),(60,'2013_12_12_055218_add_manager_to_users_table',1),(61,'2014_01_28_031200_add_qr_code_to_settings_table',1),(62,'2014_02_13_183016_add_qr_text_to_settings_table',1),(63,'2014_05_24_093839_alter_default_license_depreciation_id',1),(64,'2014_05_27_231658_alter_default_values_licenses',1),(65,'2014_06_19_191508_add_asset_name_to_settings',1),(66,'2014_06_20_004847_make_asset_log_checkedout_to_nullable',1),(67,'2014_06_20_005050_make_asset_log_purchasedate_to_nullable',1),(68,'2014_06_24_003011_add_suppliers',1),(69,'2014_06_24_010742_add_supplier_id_to_asset',1),(70,'2014_06_24_012839_add_zip_to_supplier',1),(71,'2014_06_24_033908_add_url_to_supplier',1),(72,'2014_07_08_054116_add_employee_id_to_users',1),(73,'2014_07_09_134316_add_requestable_to_assets',1),(74,'2014_07_17_085822_add_asset_to_software',1),(75,'2014_07_17_161625_make_asset_id_in_logs_nullable',1),(76,'2014_08_12_053504_alpha_0_4_2_release',1),(77,'2014_08_17_083523_make_location_id_nullable',1),(78,'2014_10_16_200626_add_rtd_location_to_assets',1),(79,'2014_10_24_000417_alter_supplier_state_to_32',1),(80,'2014_10_24_015641_add_display_checkout_date',1),(81,'2014_10_28_222654_add_avatar_field_to_users_table',1),(82,'2014_10_29_045924_add_image_field_to_models_table',1),(83,'2014_11_01_214955_add_eol_display_to_settings',1),(84,'2014_11_04_231416_update_group_field_for_reporting',1),(85,'2014_11_05_212408_add_fields_to_licenses',1),(86,'2014_11_07_021042_add_image_to_supplier',1),(87,'2014_11_20_203007_add_username_to_user',1),(88,'2014_11_20_223947_add_auto_to_settings',1),(89,'2014_11_20_224421_add_prefix_to_settings',1),(90,'2014_11_21_104401_change_licence_type',1),(91,'2014_12_09_082500_add_fields_maintained_term_to_licenses',1),(92,'2015_02_04_155757_increase_user_field_lengths',1),(93,'2015_02_07_013537_add_soft_deleted_to_log',1),(94,'2015_02_10_040958_fix_bad_assigned_to_ids',1),(95,'2015_02_10_053310_migrate_data_to_new_statuses',1),(96,'2015_02_11_044104_migrate_make_license_assigned_null',1),(97,'2015_02_11_104406_migrate_create_requests_table',1),(98,'2015_02_12_001312_add_mac_address_to_asset',1),(99,'2015_02_12_024100_change_license_notes_type',1),(100,'2015_02_17_231020_add_localonly_to_settings',1),(101,'2015_02_19_222322_add_logo_and_colors_to_settings',1),(102,'2015_02_24_072043_add_alerts_to_settings',1),(103,'2015_02_25_022931_add_eula_fields',1),(104,'2015_02_25_204513_add_accessories_table',1),(105,'2015_02_26_091228_add_accessories_user_table',1),(106,'2015_02_26_115128_add_deleted_at_models',1),(107,'2015_02_26_233005_add_category_type',1),(108,'2015_03_01_231912_update_accepted_at_to_acceptance_id',1),(109,'2015_03_05_011929_add_qr_type_to_settings',1),(110,'2015_03_18_055327_add_note_to_user',1),(111,'2015_04_29_234704_add_slack_to_settings',1),(112,'2015_05_04_085151_add_parent_id_to_locations_table',1),(113,'2015_05_22_124421_add_reassignable_to_licenses',1),(114,'2015_06_10_003314_fix_default_for_user_notes',1),(115,'2015_06_10_003554_create_consumables',1),(116,'2015_06_15_183253_move_email_to_username',1),(117,'2015_06_23_070346_make_email_nullable',1),(118,'2015_06_26_213716_create_asset_maintenances_table',1),(119,'2015_07_04_212443_create_custom_fields_table',1),(120,'2015_07_09_014359_add_currency_to_settings_and_locations',1),(121,'2015_07_21_122022_add_expected_checkin_date_to_asset_logs',1),(122,'2015_07_24_093845_add_checkin_email_to_category_table',1),(123,'2015_07_25_055415_remove_email_unique_constraint',1),(124,'2015_07_29_230054_add_thread_id_to_asset_logs_table',1),(125,'2015_07_31_015430_add_accepted_to_assets',1),(126,'2015_09_09_195301_add_custom_css_to_settings',1),(127,'2015_09_21_235926_create_custom_field_custom_fieldset',1),(128,'2015_09_22_000104_create_custom_fieldsets',1),(129,'2015_09_22_003321_add_fieldset_id_to_assets',1),(130,'2015_09_22_003413_migrate_mac_address',1),(131,'2015_09_28_003314_fix_default_purchase_order',1),(132,'2015_10_01_024551_add_accessory_consumable_price_info',1),(133,'2015_10_12_192706_add_brand_to_settings',1),(134,'2015_10_22_003314_fix_defaults_accessories',1),(135,'2015_10_23_182625_add_checkout_time_and_expected_checkout_date_to_assets',1),(136,'2015_11_05_061015_create_companies_table',1),(137,'2015_11_05_061115_add_company_id_to_consumables_table',1),(138,'2015_11_05_183749_image',1),(139,'2015_11_06_092038_add_company_id_to_accessories_table',1),(140,'2015_11_06_100045_add_company_id_to_users_table',1),(141,'2015_11_06_134742_add_company_id_to_licenses_table',1),(142,'2015_11_08_035832_add_company_id_to_assets_table',1),(143,'2015_11_08_222305_add_ldap_fields_to_settings',1),(144,'2015_11_15_151803_add_full_multiple_companies_support_to_settings_table',1),(145,'2015_11_26_195528_import_ldap_settings',1),(146,'2015_11_30_191504_remove_fk_company_id',1),(147,'2015_12_21_193006_add_ldap_server_cert_ignore_to_settings_table',1),(148,'2015_12_30_233509_add_timestamp_and_userId_to_custom_fields',1),(149,'2015_12_30_233658_add_timestamp_and_userId_to_custom_fieldsets',1),(150,'2016_01_28_041048_add_notes_to_models',1),(151,'2016_02_19_070119_add_remember_token_to_users_table',1),(152,'2016_02_19_073625_create_password_resets_table',1),(153,'2016_03_02_193043_add_ldap_flag_to_users',1),(154,'2016_03_02_220517_update_ldap_filter_to_longer_field',1),(155,'2016_03_08_225351_create_components_table',1),(156,'2016_03_09_024038_add_min_stock_to_tables',1),(157,'2016_03_10_133849_add_locale_to_users',1),(158,'2016_03_10_135519_add_locale_to_settings',1),(159,'2016_03_11_185621_add_label_settings_to_settings',1),(160,'2016_03_22_125911_fix_custom_fields_regexes',1),(161,'2016_04_28_141554_add_show_to_users',1),(162,'2016_05_16_164733_add_model_mfg_to_consumable',1),(163,'2016_05_19_180351_add_alt_barcode_settings',1),(164,'2016_05_19_191146_add_alter_interval',1),(165,'2016_05_19_192226_add_inventory_threshold',1),(166,'2016_05_20_024859_remove_option_keys_from_settings_table',1),(167,'2016_05_20_143758_remove_option_value_from_settings_table',1),(168,'2016_06_01_000001_create_oauth_auth_codes_table',1),(169,'2016_06_01_000002_create_oauth_access_tokens_table',1),(170,'2016_06_01_000003_create_oauth_refresh_tokens_table',1),(171,'2016_06_01_000004_create_oauth_clients_table',1),(172,'2016_06_01_000005_create_oauth_personal_access_clients_table',1),(173,'2016_06_01_140218_add_email_domain_and_format_to_settings',1),(174,'2016_06_22_160725_add_user_id_to_maintenances',1),(175,'2016_07_13_150015_add_is_ad_to_settings',1),(176,'2016_07_14_153609_add_ad_domain_to_settings',1),(177,'2016_07_22_003348_fix_custom_fields_regex_stuff',1),(178,'2016_07_22_054850_one_more_mac_addr_fix',1),(179,'2016_07_22_143045_add_port_to_ldap_settings',1),(180,'2016_07_22_153432_add_tls_to_ldap_settings',1),(181,'2016_07_27_211034_add_zerofill_to_settings',1),(182,'2016_08_02_124944_add_color_to_statuslabel',1),(183,'2016_08_04_134500_add_disallow_ldap_pw_sync_to_settings',1),(184,'2016_08_09_002225_add_manufacturer_to_licenses',1),(185,'2016_08_12_121613_add_manufacturer_to_accessories_table',1),(186,'2016_08_23_143353_add_new_fields_to_custom_fields',1),(187,'2016_08_23_145619_add_show_in_nav_to_status_labels',1),(188,'2016_08_30_084634_make_purchase_cost_nullable',1),(189,'2016_09_01_141051_add_requestable_to_asset_model',1),(190,'2016_09_02_001448_create_checkout_requests_table',1),(191,'2016_09_04_180400_create_actionlog_table',1),(192,'2016_09_04_182149_migrate_asset_log_to_action_log',1),(193,'2016_09_19_235935_fix_fieldtype_for_target_type',1),(194,'2016_09_23_140722_fix_modelno_in_consumables_to_string',1),(195,'2016_09_28_231359_add_company_to_logs',1),(196,'2016_10_14_130709_fix_order_number_to_varchar',1),(197,'2016_10_16_015024_rename_modelno_to_model_number',1),(198,'2016_10_16_015211_rename_consumable_modelno_to_model_number',1),(199,'2016_10_16_143235_rename_model_note_to_notes',1),(200,'2016_10_16_165052_rename_component_total_qty_to_qty',1),(201,'2016_10_19_145520_fix_order_number_in_components_to_string',1),(202,'2016_10_27_151715_add_serial_to_components',1),(203,'2016_10_27_213251_increase_serial_field_capacity',1),(204,'2016_10_29_002724_enable_2fa_fields',1),(205,'2016_10_29_082408_add_signature_to_acceptance',1),(206,'2016_11_01_030818_fix_forgotten_filename_in_action_logs',1),(207,'2016_11_13_020954_rename_component_serial_number_to_serial',1),(208,'2016_11_16_172119_increase_purchase_cost_size',1),(209,'2016_11_17_161317_longer_state_field_in_location',1),(210,'2016_11_17_193706_add_model_number_to_accessories',1),(211,'2016_11_24_160405_add_missing_target_type_to_logs_table',1),(212,'2016_12_07_173720_increase_size_of_state_in_suppliers',1),(213,'2016_12_19_004212_adjust_locale_length_to_10',1),(214,'2016_12_19_133936_extend_phone_lengths_in_supplier_and_elsewhere',1),(215,'2016_12_27_212631_make_asset_assigned_to_polymorphic',1),(216,'2017_01_09_040429_create_locations_ldap_query_field',1),(217,'2017_01_14_002418_create_imports_table',1),(218,'2017_01_25_063357_fix_utf8_custom_field_column_names',1),(219,'2017_03_03_154632_add_time_date_display_to_settings',1),(220,'2017_03_10_210807_add_fields_to_manufacturer',1),(221,'2017_05_08_195520_increase_size_of_field_values_in_custom_fields',1),(222,'2017_05_22_204422_create_departments',1),(223,'2017_05_22_233509_add_manager_to_locations_table',1),(224,'2017_06_14_122059_add_next_autoincrement_to_settings',1),(225,'2017_06_18_151753_add_header_and_first_row_to_importer_table',1),(226,'2017_07_07_191533_add_login_text',1),(227,'2017_07_25_130710_add_thumbsize_to_settings',1),(228,'2017_08_03_160105_set_asset_archived_to_zero_default',1),(229,'2017_08_22_180636_add_secure_password_options',1),(230,'2017_08_25_074822_add_auditing_tables',1),(231,'2017_08_25_101435_add_auditing_to_settings',1),(232,'2017_09_18_225619_fix_assigned_type_not_being_nulled',1),(233,'2017_10_03_015503_drop_foreign_keys',1),(234,'2017_10_10_123504_allow_nullable_depreciation_id_in_models',1),(235,'2017_10_17_133709_add_display_url_to_settings',1),(236,'2017_10_19_120002_add_custom_forgot_password_url',1),(237,'2017_10_19_130406_add_image_and_supplier_to_accessories',1),(238,'2017_10_20_234129_add_location_indices_to_assets',1),(239,'2017_10_25_202930_add_images_uploads_to_locations_manufacturers_etc',1),(240,'2017_10_27_180947_denorm_asset_locations',1),(241,'2017_10_27_192423_migrate_denormed_asset_locations',1),(242,'2017_10_30_182938_add_address_to_user',1),(243,'2017_11_08_025918_add_alert_menu_setting',1),(244,'2017_11_08_123942_labels_display_company_name',1),(245,'2017_12_12_010457_normalize_asset_last_audit_date',1),(246,'2017_12_12_033618_add_actionlog_meta',1),(247,'2017_12_26_170856_re_normalize_last_audit',1),(248,'2018_01_17_184354_add_archived_in_list_setting',1),(249,'2018_01_19_203121_add_dashboard_message_to_settings',1),(250,'2018_01_24_062633_add_footer_settings_to_settings',1),(251,'2018_01_24_093426_add_modellist_preferenc',1),(252,'2018_02_22_160436_add_remote_user_settings',1),(253,'2018_03_03_011032_add_theme_to_settings',1),(254,'2018_03_06_054937_add_default_flag_on_statuslabels',1),(255,'2018_03_23_212048_add_display_in_email_to_custom_fields',1),(256,'2018_03_24_030738_add_show_images_in_email_setting',1),(257,'2018_03_24_050108_add_cc_alerts',1),(258,'2018_03_29_053618_add_canceled_at_and_fulfilled_at_in_requests',1),(259,'2018_03_29_070121_add_drop_unique_requests',1),(260,'2018_03_29_070511_add_new_index_requestable',1),(261,'2018_04_02_150700_labels_display_model_name',1),(262,'2018_04_16_133902_create_custom_field_default_values_table',1),(263,'2018_05_04_073223_add_category_to_licenses',1),(264,'2018_05_04_075235_add_update_license_category',1),(265,'2018_05_08_031515_add_gdpr_privacy_footer',1),(266,'2018_05_14_215229_add_indexes',1),(267,'2018_05_14_223646_add_indexes_to_assets',1),(268,'2018_05_14_233638_denorm_counters_on_assets',1),(269,'2018_05_16_153409_add_first_counter_totals_to_assets',1),(270,'2018_06_21_134622_add_version_footer',1),(271,'2018_07_05_215440_add_unique_serial_option_to_settings',1),(272,'2018_07_17_005911_create_login_attempts_table',1),(273,'2018_07_24_154348_add_logo_to_print_assets',1),(274,'2018_07_28_023826_create_checkout_acceptances_table',1),(275,'2018_08_20_204842_add_depreciation_option_to_settings',1),(276,'2018_09_10_082212_create_checkout_acceptances_for_unaccepted_assets',1),(277,'2018_10_18_191228_add_kits_licenses_table',1),(278,'2018_10_19_153910_add_kits_table',1),(279,'2018_10_19_154013_add_kits_models_table',1),(280,'2018_12_05_211936_add_favicon_to_settings',1),(281,'2018_12_05_212119_add_email_logo_to_settings',1),(282,'2019_02_07_185953_add_kits_consumables_table',1),(283,'2019_02_07_190030_add_kits_accessories_table',1),(284,'2019_02_12_182750_add_actiondate_to_actionlog',1),(285,'2019_02_14_154310_change_auto_increment_prefix_to_nullable',1),(286,'2019_02_16_143518_auto_increment_back_to_string',1),(287,'2019_02_17_205048_add_label_logo_to_settings',1),(288,'2019_02_20_234421_make_serial_nullable',1),(289,'2019_02_21_224703_make_fields_nullable_for_integrity',1),(290,'2019_06_12_184327_rename_groups_table',1),(291,'2019_07_23_140906_add_show_assigned_assets_to_settings',1),(292,'2019_08_20_084049_add_custom_remote_user_header',1),(293,'2019_12_04_223111_passport_upgrade',1),(294,'2020_02_04_172100_add_ad_append_domain_settings',1),(295,'2020_04_29_222305_add_saml_fields_to_settings',1),(296,'2020_10_22_233743_move_accessory_checkout_note_to_join_table',1),(297,'2020_10_23_161736_fix_zero_values_for_locations',1),(298,'2020_11_18_214827_widen_license_serial_field',1),(299,'2020_12_14_233815_add_digit_separator_to_settings',1),(300,'2020_12_18_090026_swap_target_type_index_order',1),(301,'2020_12_21_153235_update_min_password',1),(302,'2020_12_21_210105_fix_bad_ldap_server_url_for_v5',1),(303,'2021_02_05_172502_add_provider_to_oauth_table',1),(304,'2013_11_15_190357_create_temp_licenses_table',2),(305,'2013_11_25_013244_recreate_licenses_table',2),(306,'2019_04_06_060145_add_user_skin_setting',2),(307,'2019_04_06_205355_add_setting_allow_user_skin',2),(308,'2020_08_11_200712_add_saml_key_rollover',2),(309,'2021_03_18_184102_adds_several_ldap_fields',2),(310,'2021_04_07_001811_add_ldap_dept',2),(311,'2021_04_14_180125_add_ids_to_tables',2),(312,'2021_06_07_155421_add_serial_number_indexes',2),(313,'2021_06_07_155436_add_company_id_indexes',2),(314,'2021_07_28_031345_add_client_side_l_d_a_p_cert_to_settings',2),(315,'2021_07_28_040554_add_client_side_l_d_a_p_key_to_settings',2),(316,'2021_08_11_005206_add_depreciation_minimum_value',2),(317,'2021_08_24_124354_make_ldap_client_certs_nullable',2),(318,'2021_09_20_183216_change_default_label_to_nullable',2),(319,'2021_12_27_151849_change_supplier_address_length',2),(320,'2022_01_10_182548_add_license_id_index_to_license_seats',2),(321,'2022_02_03_214958_blank_out_ldap_active_flag',2),(322,'2022_02_16_152431_add_unique_constraint_to_custom_field',2),(323,'2022_03_03_225655_add_notes_to_accessories',2),(324,'2022_03_03_225754_add_notes_to_components',2),(325,'2022_03_03_225824_add_notes_to_consumables',2),(326,'2022_03_04_080836_add_remote_to_user',2),(327,'2022_03_09_001334_add_eula_to_checkout_acceptance',2),(328,'2022_03_10_175740_add_eula_to_action_logs',2),(329,'2022_03_21_162724_adds_ldap_manager',2),(330,'2022_04_05_135340_add_primary_key_to_custom_fields_pivot',2);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `models`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `models` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `manufacturer_id` int DEFAULT NULL,
  `category_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `depreciation_id` int DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `eol` int DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deprecated_mac_address` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `fieldset_id` int DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `requestable` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `models` WRITE;
/*!40000 ALTER TABLE `models` DISABLE KEYS */;
INSERT INTO `models` VALUES (1,'Drill','M12 FPD',1,2,'2021-02-23 10:46:53','2021-02-23 10:46:53',NULL,1,0,NULL,0,NULL,NULL,NULL,0),(2,'Corrugated Tube Cutter','EW-12A',3,5,'2021-04-27 08:09:54','2021-04-27 08:09:54',NULL,1,60,'assetmodel-image-p4yJTbh86X.jpg',0,NULL,NULL,NULL,0),(3,'101 Multimeter','101',5,2,'2021-07-12 09:50:39','2022-05-18 14:36:22',NULL,1,0,'assetmodel-image-qffupr6Hsm.jpg',0,NULL,NULL,NULL,0),(4,'107 Multimeter','107',5,2,'2021-07-12 09:50:58','2022-05-18 14:31:44',NULL,1,0,'assetmodel-image-RMqrEXq2Wr.jpg',0,NULL,NULL,NULL,0),(5,'PT-50 Compressor 50L 8Bar','PT-50',6,5,'2022-05-18 14:33:42','2022-05-18 14:35:42',NULL,1,0,'assetmodel-image-btKMGk7Uol.jpg',0,NULL,NULL,NULL,0),(6,'Receiver ','S3000050',6,5,'2022-06-01 14:42:34','2022-06-01 14:42:34',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0),(7,'CCTV test Monitor AHD, CVI, CVBS and UTC','BW 4 in 1 CCTV Tester Support 720P/1080P/3mp/4mp/5mp AHD, TVI, CVI, CVBS Analog Camera, Security Video Monitor with 4.3 inch LCD Screen DC12V 1A Power Output, UTP Cable Tester, PTZ Control',NULL,2,'2022-06-01 15:04:20','2022-06-01 15:04:20',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0),(8,'HD CCTV Tester','HD-6300W',NULL,2,'2022-06-01 15:07:23','2022-06-01 15:07:23',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0),(9,'Injection Mould Tool for 303777','303775',NULL,5,'2022-06-08 13:41:27','2022-06-08 13:41:27',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0),(10,'Maypole Smart Charger','MP7423',NULL,2,'2022-06-08 14:41:57','2022-06-08 14:41:57',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0);
/*!40000 ALTER TABLE `models` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `models_custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `models_custom_fields` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_model_id` int NOT NULL,
  `custom_field_id` int NOT NULL,
  `default_value` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `models_custom_fields` WRITE;
/*!40000 ALTER TABLE `models_custom_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `models_custom_fields` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_access_tokens` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `client_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `scopes` text COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_access_tokens_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_access_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_auth_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_auth_codes` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `client_id` bigint unsigned NOT NULL,
  `scopes` text COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_auth_codes_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_auth_codes` WRITE;
/*!40000 ALTER TABLE `oauth_auth_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_auth_codes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_clients` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `provider` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `redirect` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_clients_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_clients` WRITE;
/*!40000 ALTER TABLE `oauth_clients` DISABLE KEYS */;
INSERT INTO `oauth_clients` VALUES (1,NULL,'Snipe-IT Personal Access Client','sDHSIvukIFzXHgIjNIHeubKbGWobuUKcTxP5dulJ',NULL,'http://localhost',1,0,0,'2021-02-23 09:31:25','2021-02-23 09:31:25'),(2,NULL,'Snipe-IT Password Grant Client','BY03K4i9qaifIZB0cj4bxNE9lEFCeG7BhCWTfqtH','users','http://localhost',0,1,0,'2021-02-23 09:31:25','2021-02-23 09:31:25'),(3,NULL,'Snipe-IT Personal Access Client','642jATPQpmkp8LQ1dcy014n57o5Jg1fvcpf0Uypn',NULL,'http://localhost',1,0,0,'2021-02-23 09:33:03','2021-02-23 09:33:03'),(4,NULL,'Snipe-IT Password Grant Client','hQt9vY2wiqQlDynA6OjhspMI1mzBtQT3s4mW1HCj','users','http://localhost',0,1,0,'2021-02-23 09:33:03','2021-02-23 09:33:03');
/*!40000 ALTER TABLE `oauth_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_personal_access_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_personal_access_clients` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `client_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_personal_access_clients` WRITE;
/*!40000 ALTER TABLE `oauth_personal_access_clients` DISABLE KEYS */;
INSERT INTO `oauth_personal_access_clients` VALUES (1,1,'2021-02-23 09:31:25','2021-02-23 09:31:25'),(2,3,'2021-02-23 09:33:03','2021-02-23 09:33:03');
/*!40000 ALTER TABLE `oauth_personal_access_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_refresh_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_refresh_tokens` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `access_token_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_refresh_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_refresh_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_refresh_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `password_resets_email_index` (`email`),
  KEY `password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permission_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `permission_groups` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permission_groups` WRITE;
/*!40000 ALTER TABLE `permission_groups` DISABLE KEYS */;
INSERT INTO `permission_groups` VALUES (1,'Super Admin','{\"superuser\":\"1\",\"admin\":\"0\",\"import\":\"0\",\"reports.view\":\"0\",\"assets.view\":\"0\",\"assets.create\":\"0\",\"assets.edit\":\"0\",\"assets.delete\":\"0\",\"assets.checkin\":\"0\",\"assets.checkout\":\"0\",\"assets.audit\":\"0\",\"assets.view.requestable\":\"0\",\"accessories.view\":\"0\",\"accessories.create\":\"0\",\"accessories.edit\":\"0\",\"accessories.delete\":\"0\",\"accessories.checkout\":\"0\",\"accessories.checkin\":\"0\",\"consumables.view\":\"0\",\"consumables.create\":\"0\",\"consumables.edit\":\"0\",\"consumables.delete\":\"0\",\"consumables.checkout\":\"0\",\"licenses.view\":\"0\",\"licenses.create\":\"0\",\"licenses.edit\":\"0\",\"licenses.delete\":\"0\",\"licenses.checkout\":\"0\",\"licenses.keys\":\"0\",\"components.view\":\"0\",\"components.create\":\"0\",\"components.edit\":\"0\",\"components.delete\":\"0\",\"components.checkout\":\"0\",\"components.checkin\":\"0\",\"kits.view\":\"0\",\"kits.create\":\"0\",\"kits.edit\":\"0\",\"kits.delete\":\"0\",\"kits.checkout\":\"0\",\"users.view\":\"0\",\"users.create\":\"0\",\"users.edit\":\"0\",\"users.delete\":\"0\",\"models.view\":\"0\",\"models.create\":\"0\",\"models.edit\":\"0\",\"models.delete\":\"0\",\"categories.view\":\"0\",\"categories.create\":\"0\",\"categories.edit\":\"0\",\"categories.delete\":\"0\",\"departments.view\":\"0\",\"departments.create\":\"0\",\"departments.edit\":\"0\",\"departments.delete\":\"0\",\"statuslabels.view\":\"0\",\"statuslabels.create\":\"0\",\"statuslabels.edit\":\"0\",\"statuslabels.delete\":\"0\",\"customfields.view\":\"0\",\"customfields.create\":\"0\",\"customfields.edit\":\"0\",\"customfields.delete\":\"0\",\"suppliers.view\":\"0\",\"suppliers.create\":\"0\",\"suppliers.edit\":\"0\",\"suppliers.delete\":\"0\",\"manufacturers.view\":\"0\",\"manufacturers.create\":\"0\",\"manufacturers.edit\":\"0\",\"manufacturers.delete\":\"0\",\"depreciations.view\":\"0\",\"depreciations.create\":\"0\",\"depreciations.edit\":\"0\",\"depreciations.delete\":\"0\",\"locations.view\":\"0\",\"locations.create\":\"0\",\"locations.edit\":\"0\",\"locations.delete\":\"0\",\"companies.view\":\"0\",\"companies.create\":\"0\",\"companies.edit\":\"0\",\"companies.delete\":\"0\",\"self.two_factor\":\"0\",\"self.api\":\"0\",\"self.edit_location\":\"0\",\"self.checkout_assets\":\"0\"}','2021-03-04 14:13:52','2021-03-04 14:13:52');
/*!40000 ALTER TABLE `permission_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `requested_assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `requested_assets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int NOT NULL,
  `user_id` int NOT NULL,
  `accepted_at` datetime DEFAULT NULL,
  `denied_at` datetime DEFAULT NULL,
  `notes` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `requested_assets` WRITE;
/*!40000 ALTER TABLE `requested_assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `requested_assets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `requests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `requests` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int NOT NULL,
  `user_id` int DEFAULT NULL,
  `request_code` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `requests` WRITE;
/*!40000 ALTER TABLE `requests` DISABLE KEYS */;
/*!40000 ALTER TABLE `requests` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `per_page` int NOT NULL DEFAULT '20',
  `site_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Snipe IT Asset Management',
  `qr_code` int DEFAULT NULL,
  `qr_text` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `display_asset_name` int DEFAULT NULL,
  `display_checkout_date` int DEFAULT NULL,
  `display_eol` int DEFAULT NULL,
  `auto_increment_assets` int NOT NULL DEFAULT '0',
  `auto_increment_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `load_remote` tinyint(1) NOT NULL DEFAULT '1',
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `header_color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alert_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alerts_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `default_eula_text` longtext COLLATE utf8mb4_unicode_ci,
  `barcode_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'QRCODE',
  `slack_endpoint` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slack_channel` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slack_botname` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_currency` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_css` text COLLATE utf8mb4_unicode_ci,
  `brand` tinyint NOT NULL DEFAULT '1',
  `ldap_enabled` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ldap_server` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ldap_uname` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ldap_pword` longtext COLLATE utf8mb4_unicode_ci,
  `ldap_basedn` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ldap_filter` text COLLATE utf8mb4_unicode_ci,
  `ldap_username_field` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'samaccountname',
  `ldap_lname_field` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'sn',
  `ldap_fname_field` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'givenname',
  `ldap_auth_filter_query` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'uid=samaccountname',
  `ldap_version` int DEFAULT '3',
  `ldap_active_flag` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ldap_dept` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ldap_emp_num` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ldap_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ldap_phone_field` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ldap_jobtitle` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ldap_manager` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ldap_country` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `full_multiple_companies_support` tinyint(1) NOT NULL DEFAULT '0',
  `ldap_server_cert_ignore` tinyint(1) NOT NULL DEFAULT '0',
  `locale` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT 'en-GB',
  `labels_per_page` tinyint NOT NULL DEFAULT '30',
  `labels_width` decimal(6,5) NOT NULL DEFAULT '2.62500',
  `labels_height` decimal(6,5) NOT NULL DEFAULT '1.00000',
  `labels_pmargin_left` decimal(6,5) NOT NULL DEFAULT '0.21975',
  `labels_pmargin_right` decimal(6,5) NOT NULL DEFAULT '0.21975',
  `labels_pmargin_top` decimal(6,5) NOT NULL DEFAULT '0.50000',
  `labels_pmargin_bottom` decimal(6,5) NOT NULL DEFAULT '0.50000',
  `labels_display_bgutter` decimal(6,5) NOT NULL DEFAULT '0.07000',
  `labels_display_sgutter` decimal(6,5) NOT NULL DEFAULT '0.05000',
  `labels_fontsize` tinyint NOT NULL DEFAULT '9',
  `labels_pagewidth` decimal(7,5) NOT NULL DEFAULT '8.50000',
  `labels_pageheight` decimal(7,5) NOT NULL DEFAULT '11.00000',
  `labels_display_name` tinyint NOT NULL DEFAULT '0',
  `labels_display_serial` tinyint NOT NULL DEFAULT '1',
  `labels_display_tag` tinyint NOT NULL DEFAULT '1',
  `alt_barcode` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'C128',
  `alt_barcode_enabled` tinyint(1) DEFAULT '1',
  `alert_interval` int DEFAULT '30',
  `alert_threshold` int DEFAULT '5',
  `email_domain` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_format` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'filastname',
  `username_format` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'filastname',
  `is_ad` tinyint(1) NOT NULL DEFAULT '0',
  `ad_domain` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ldap_port` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '389',
  `ldap_tls` tinyint(1) NOT NULL DEFAULT '0',
  `zerofill_count` int NOT NULL DEFAULT '5',
  `ldap_pw_sync` tinyint(1) NOT NULL DEFAULT '1',
  `two_factor_enabled` tinyint DEFAULT NULL,
  `require_accept_signature` tinyint(1) NOT NULL DEFAULT '0',
  `date_display_format` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y-m-d',
  `time_display_format` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'h:i A',
  `next_auto_tag_base` bigint NOT NULL DEFAULT '1',
  `login_note` text COLLATE utf8mb4_unicode_ci,
  `thumbnail_max_h` int DEFAULT '50',
  `pwd_secure_uncommon` tinyint(1) NOT NULL DEFAULT '0',
  `pwd_secure_complexity` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pwd_secure_min` int NOT NULL DEFAULT '8',
  `audit_interval` int DEFAULT NULL,
  `audit_warning_days` int DEFAULT NULL,
  `show_url_in_emails` tinyint(1) NOT NULL DEFAULT '0',
  `custom_forgot_pass_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_alerts_in_menu` tinyint(1) NOT NULL DEFAULT '1',
  `labels_display_company_name` tinyint(1) NOT NULL DEFAULT '0',
  `show_archived_in_list` tinyint(1) NOT NULL DEFAULT '0',
  `dashboard_message` text COLLATE utf8mb4_unicode_ci,
  `support_footer` char(5) COLLATE utf8mb4_unicode_ci DEFAULT 'on',
  `footer_text` text COLLATE utf8mb4_unicode_ci,
  `modellist_displays` char(191) COLLATE utf8mb4_unicode_ci DEFAULT 'image,category,manufacturer,model_number',
  `login_remote_user_enabled` tinyint(1) NOT NULL DEFAULT '0',
  `login_common_disabled` tinyint(1) NOT NULL DEFAULT '0',
  `login_remote_user_custom_logout_url` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `skin` char(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_images_in_email` tinyint(1) NOT NULL DEFAULT '1',
  `admin_cc_email` char(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `labels_display_model` tinyint(1) NOT NULL DEFAULT '0',
  `privacy_policy_link` char(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `version_footer` char(5) COLLATE utf8mb4_unicode_ci DEFAULT 'on',
  `unique_serial` tinyint(1) NOT NULL DEFAULT '0',
  `logo_print_assets` tinyint(1) NOT NULL DEFAULT '0',
  `depreciation_method` char(10) COLLATE utf8mb4_unicode_ci DEFAULT 'default',
  `favicon` char(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_logo` char(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `label_logo` char(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_assigned_assets` tinyint(1) NOT NULL DEFAULT '0',
  `login_remote_user_header_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ad_append_domain` tinyint(1) NOT NULL DEFAULT '0',
  `saml_enabled` tinyint(1) NOT NULL DEFAULT '0',
  `saml_idp_metadata` text COLLATE utf8mb4_unicode_ci,
  `saml_attr_mapping_username` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `saml_forcelogin` tinyint(1) NOT NULL DEFAULT '0',
  `saml_slo` tinyint(1) NOT NULL DEFAULT '0',
  `saml_sp_x509cert` text COLLATE utf8mb4_unicode_ci,
  `saml_sp_privatekey` text COLLATE utf8mb4_unicode_ci,
  `saml_custom_settings` text COLLATE utf8mb4_unicode_ci,
  `digit_separator` char(191) COLLATE utf8mb4_unicode_ci DEFAULT '1234.56',
  `allow_user_skin` tinyint(1) NOT NULL DEFAULT '0',
  `saml_sp_x509certNew` text COLLATE utf8mb4_unicode_ci,
  `ldap_client_tls_cert` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `ldap_client_tls_key` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (1,'2021-02-23 09:35:43','2022-06-08 14:44:22',1,20,'TVG Asset Management',NULL,NULL,NULL,NULL,NULL,0,NULL,1,'setting-logo-fpJI5QpDUP.png',NULL,'mf@tvg.uk',1,NULL,'QRCODE',NULL,NULL,NULL,'GBP',NULL,1,'1','ldaps://remote.thevehiclegroup.com','CN=ldaps,OU=Service Accounts,OU=TheVehicleGroup,DC=tvgl,DC=local','eyJpdiI6Ik5qbDNMdzkrMFdyUmZTVzNtd2Nxa1E9PSIsInZhbHVlIjoiXC9jXC8zYU00Q2J5c3JIWUV6MEFHekI2WFwvdWcrNmNSdm1QQ0wxM0V6Q0hMND0iLCJtYWMiOiJlOWQ2NTYwODcxMDQ1ZjVkYWYyNWNkOTBiYjlhNDE2NmJmNWJhOGFjZWRkZWU2NWJhZGY0OTI2ODE3MzY3MmJlIn0=','OU=TheVehicleGroup,DC=tvgl,DC=local','&(&(sAMAccountType=805306368)(|(userAccountControl=512)(userAccountControl=66048)))(memberOf:1.2.840.113556.1.4.1941:=CN=TVG Asset Management,OU=Systems Access,OU=Groups,OU=TheVehicleGroup,DC=tvgl,DC=local)','samaccountname','sn','givenname','sAMAccountName=',3,NULL,NULL,NULL,'mail',NULL,NULL,NULL,NULL,0,1,'en-GB',30,2.62500,1.00000,0.21975,0.21975,0.50000,0.50000,0.07000,0.05000,9,8.50000,11.00000,0,1,1,'C128',1,30,5,'tvg.uk','filastname','filastname',1,'tvgl.local','389',0,5,1,NULL,0,'Y-m-d','h:i A',23,NULL,50,0,NULL,10,NULL,NULL,0,NULL,1,0,0,NULL,'off',NULL,'image,category,manufacturer,model_number',0,0,'','blue',1,NULL,0,NULL,'off',0,0,'default','favicon-uploaded.png','setting-email_logo-kdDfQs6P65.png','setting-label_logo-P8kreKQ0iL.png',0,'',0,0,NULL,NULL,0,0,NULL,NULL,NULL,'1234.56',0,NULL,NULL,NULL);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `status_labels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `status_labels` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `deployable` tinyint(1) NOT NULL DEFAULT '0',
  `pending` tinyint(1) NOT NULL DEFAULT '0',
  `archived` tinyint(1) NOT NULL DEFAULT '0',
  `notes` text COLLATE utf8mb4_unicode_ci,
  `color` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_in_nav` tinyint(1) DEFAULT '0',
  `default_label` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `status_labels` WRITE;
/*!40000 ALTER TABLE `status_labels` DISABLE KEYS */;
INSERT INTO `status_labels` VALUES (1,'Pending',1,NULL,NULL,NULL,0,1,0,'These assets are not yet ready to be deployed, usually because of configuration or waiting on parts.',NULL,0,0),(2,'Ready to Deploy',1,NULL,NULL,NULL,1,0,0,'These assets are ready to deploy.',NULL,0,0),(3,'Archived',1,NULL,NULL,NULL,0,0,1,'These assets are no longer in circulation or viable.',NULL,0,0);
/*!40000 ALTER TABLE `status_labels` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address2` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(2) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(35) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fax` varchar(35) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notes` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `zip` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
INSERT INTO `suppliers` VALUES (1,'TVG',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-03-04 13:29:52','2021-03-04 13:29:52',NULL,NULL,NULL,NULL,NULL),(2,'Teltonika',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-03-05 09:08:43','2021-03-05 09:08:43',NULL,NULL,NULL,NULL,NULL),(3,'Bambi Air Ltd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-06-01 14:33:48','2022-06-01 14:33:48',NULL,NULL,NULL,NULL,NULL),(4,'Air Supplies',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-06-01 14:34:39','2022-06-01 14:34:39',NULL,NULL,NULL,NULL,NULL),(5,'amazon',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-06-01 15:04:58','2022-06-01 15:04:58',NULL,NULL,NULL,NULL,NULL),(6,'IVM Limited',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-06-08 13:39:06','2022-06-08 13:39:06',NULL,NULL,NULL,NULL,NULL),(7,'IVM Ltd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-06-08 13:44:48','2022-06-08 13:44:48',NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `throttle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `throttle` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned DEFAULT NULL,
  `ip_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attempts` int NOT NULL DEFAULT '0',
  `suspended` tinyint(1) NOT NULL DEFAULT '0',
  `banned` tinyint(1) NOT NULL DEFAULT '0',
  `last_attempt_at` timestamp NULL DEFAULT NULL,
  `suspended_at` timestamp NULL DEFAULT NULL,
  `banned_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `throttle_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `throttle` WRITE;
/*!40000 ALTER TABLE `throttle` DISABLE KEYS */;
/*!40000 ALTER TABLE `throttle` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `activated` tinyint(1) NOT NULL DEFAULT '0',
  `activation_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `activated_at` timestamp NULL DEFAULT NULL,
  `last_login` timestamp NULL DEFAULT NULL,
  `persist_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reset_password_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gravatar` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_id` int DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `jobtitle` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `manager_id` int DEFAULT NULL,
  `employee_num` text COLLATE utf8mb4_unicode_ci,
  `avatar` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `company_id` int unsigned DEFAULT NULL,
  `remember_token` text COLLATE utf8mb4_unicode_ci,
  `ldap_import` tinyint(1) NOT NULL DEFAULT '0',
  `locale` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT 'en-GB',
  `show_in_list` tinyint(1) NOT NULL DEFAULT '1',
  `two_factor_secret` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `two_factor_enrolled` tinyint(1) NOT NULL DEFAULT '0',
  `two_factor_optin` tinyint(1) NOT NULL DEFAULT '0',
  `department_id` int DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `skin` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remote` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `users_activation_code_index` (`activation_code`),
  KEY `users_reset_password_code_index` (`reset_password_code`),
  KEY `users_company_id_index` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'mf@tvg.uk','$2y$10$RvvAfuaU/SIJqeoKqSmMK.gKX7Ey7Z9Tps4uG4yx9Jeigwfz0rZgG','{\"superuser\":\"1\",\"admin\":\"0\",\"import\":\"0\",\"reports.view\":\"0\",\"assets.view\":\"0\",\"assets.create\":\"0\",\"assets.edit\":\"0\",\"assets.delete\":\"0\",\"assets.checkin\":\"0\",\"assets.checkout\":\"0\",\"assets.audit\":\"0\",\"assets.view.requestable\":\"0\",\"accessories.view\":\"0\",\"accessories.create\":\"0\",\"accessories.edit\":\"0\",\"accessories.delete\":\"0\",\"accessories.checkout\":\"0\",\"accessories.checkin\":\"0\",\"consumables.view\":\"0\",\"consumables.create\":\"0\",\"consumables.edit\":\"0\",\"consumables.delete\":\"0\",\"consumables.checkout\":\"0\",\"licenses.view\":\"0\",\"licenses.create\":\"0\",\"licenses.edit\":\"0\",\"licenses.delete\":\"0\",\"licenses.checkout\":\"0\",\"licenses.keys\":\"0\",\"licenses.files\":\"0\",\"components.view\":\"0\",\"components.create\":\"0\",\"components.edit\":\"0\",\"components.delete\":\"0\",\"components.checkout\":\"0\",\"components.checkin\":\"0\",\"kits.view\":\"0\",\"kits.create\":\"0\",\"kits.edit\":\"0\",\"kits.delete\":\"0\",\"kits.checkout\":\"0\",\"users.view\":\"0\",\"users.create\":\"0\",\"users.edit\":\"0\",\"users.delete\":\"0\",\"models.view\":\"0\",\"models.create\":\"0\",\"models.edit\":\"0\",\"models.delete\":\"0\",\"categories.view\":\"0\",\"categories.create\":\"0\",\"categories.edit\":\"0\",\"categories.delete\":\"0\",\"departments.view\":\"0\",\"departments.create\":\"0\",\"departments.edit\":\"0\",\"departments.delete\":\"0\",\"statuslabels.view\":\"0\",\"statuslabels.create\":\"0\",\"statuslabels.edit\":\"0\",\"statuslabels.delete\":\"0\",\"customfields.view\":\"0\",\"customfields.create\":\"0\",\"customfields.edit\":\"0\",\"customfields.delete\":\"0\",\"suppliers.view\":\"0\",\"suppliers.create\":\"0\",\"suppliers.edit\":\"0\",\"suppliers.delete\":\"0\",\"manufacturers.view\":\"0\",\"manufacturers.create\":\"0\",\"manufacturers.edit\":\"0\",\"manufacturers.delete\":\"0\",\"depreciations.view\":\"0\",\"depreciations.create\":\"0\",\"depreciations.edit\":\"0\",\"depreciations.delete\":\"0\",\"locations.view\":\"0\",\"locations.create\":\"0\",\"locations.edit\":\"0\",\"locations.delete\":\"0\",\"companies.view\":\"0\",\"companies.create\":\"0\",\"companies.edit\":\"0\",\"companies.delete\":\"0\",\"self.two_factor\":\"0\",\"self.api\":\"0\",\"self.edit_location\":\"0\",\"self.checkout_assets\":\"0\"}',1,NULL,NULL,'2022-07-01 06:36:28',NULL,NULL,'MF','TVG Admin','2021-02-23 09:35:43','2022-07-01 06:36:28',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'mfa',NULL,NULL,'ivOSgFKxSnZtBuxcLlYy5bRqg4zSypfBiEM5vo3NN70Fn2cwPLerXybxNpXl',0,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(5,'Adrian.Brooks@tvg.uk','$2y$10$fyOuC.JbzlzEo5O77iHqIOcJfMCKe6LEYq7JI4b72LIgn74IFxhjO','{\"superuser\":\"0\",\"admin\":\"0\",\"import\":\"0\",\"reports.view\":\"0\",\"assets.view\":\"0\",\"assets.create\":\"0\",\"assets.edit\":\"0\",\"assets.delete\":\"0\",\"assets.checkin\":\"0\",\"assets.checkout\":\"0\",\"assets.audit\":\"0\",\"assets.view.requestable\":\"0\",\"accessories.view\":\"0\",\"accessories.create\":\"0\",\"accessories.edit\":\"0\",\"accessories.delete\":\"0\",\"accessories.checkout\":\"0\",\"accessories.checkin\":\"0\",\"consumables.view\":\"0\",\"consumables.create\":\"0\",\"consumables.edit\":\"0\",\"consumables.delete\":\"0\",\"consumables.checkout\":\"0\",\"licenses.view\":\"0\",\"licenses.create\":\"0\",\"licenses.edit\":\"0\",\"licenses.delete\":\"0\",\"licenses.checkout\":\"0\",\"licenses.keys\":\"0\",\"components.view\":\"0\",\"components.create\":\"0\",\"components.edit\":\"0\",\"components.delete\":\"0\",\"components.checkout\":\"0\",\"components.checkin\":\"0\",\"kits.view\":\"0\",\"kits.create\":\"0\",\"kits.edit\":\"0\",\"kits.delete\":\"0\",\"kits.checkout\":\"0\",\"users.view\":\"0\",\"users.create\":\"0\",\"users.edit\":\"0\",\"users.delete\":\"0\",\"models.view\":\"0\",\"models.create\":\"0\",\"models.edit\":\"0\",\"models.delete\":\"0\",\"categories.view\":\"0\",\"categories.create\":\"0\",\"categories.edit\":\"0\",\"categories.delete\":\"0\",\"departments.view\":\"0\",\"departments.create\":\"0\",\"departments.edit\":\"0\",\"departments.delete\":\"0\",\"statuslabels.view\":\"0\",\"statuslabels.create\":\"0\",\"statuslabels.edit\":\"0\",\"statuslabels.delete\":\"0\",\"customfields.view\":\"0\",\"customfields.create\":\"0\",\"customfields.edit\":\"0\",\"customfields.delete\":\"0\",\"suppliers.view\":\"0\",\"suppliers.create\":\"0\",\"suppliers.edit\":\"0\",\"suppliers.delete\":\"0\",\"manufacturers.view\":\"0\",\"manufacturers.create\":\"0\",\"manufacturers.edit\":\"0\",\"manufacturers.delete\":\"0\",\"depreciations.view\":\"0\",\"depreciations.create\":\"0\",\"depreciations.edit\":\"0\",\"depreciations.delete\":\"0\",\"locations.view\":\"0\",\"locations.create\":\"0\",\"locations.edit\":\"0\",\"locations.delete\":\"0\",\"companies.view\":\"0\",\"companies.create\":\"0\",\"companies.edit\":\"0\",\"companies.delete\":\"0\",\"self.two_factor\":\"0\",\"self.api\":\"0\",\"self.edit_location\":\"0\",\"self.checkout_assets\":\"0\"}',1,NULL,NULL,NULL,NULL,NULL,'Adrian','Brooks','2021-02-23 09:58:45','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'Adrian.Brooks',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(6,'miles.frankland@thevehiclegroup.com','$2y$10$rzfdZSP7coyW21CBk4s4cOrbeWmm/GUlOuKCvNKFlVLHXhUWerfZe',NULL,1,NULL,NULL,'2022-07-01 06:36:02',NULL,NULL,'Miles','Frankland','2021-02-23 10:35:40','2022-07-01 06:36:02',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'mf','Imported on first login from LDAP2',NULL,'HZrnqiWVcRcVRALAJKMjpvSpxqGlKZPchwdjCN8w3jwXL2vulOoZ0mWeyda9',1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(7,'Mike.Pratt@thevehiclegroup.com','$2y$10$nnSaEcdLYtgcd7pahHPpWeN3kI6K1vUkiGMC6Pl8fRMJ73pk4mOee',NULL,1,NULL,NULL,NULL,NULL,NULL,'Mike','Pratt','2021-02-23 10:35:40','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'Mike.Pratt',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(8,'Claire.Palmer@thevehiclegroup.com','$2y$10$nnSaEcdLYtgcd7pahHPpWeN3kI6K1vUkiGMC6Pl8fRMJ73pk4mOee','{\"superuser\":\"0\",\"admin\":\"0\",\"import\":\"0\",\"reports.view\":\"0\",\"assets.view\":\"0\",\"assets.create\":\"0\",\"assets.edit\":\"0\",\"assets.delete\":\"0\",\"assets.checkin\":\"0\",\"assets.checkout\":\"0\",\"assets.audit\":\"0\",\"assets.view.requestable\":\"0\",\"accessories.view\":\"0\",\"accessories.create\":\"0\",\"accessories.edit\":\"0\",\"accessories.delete\":\"0\",\"accessories.checkout\":\"0\",\"accessories.checkin\":\"0\",\"consumables.view\":\"0\",\"consumables.create\":\"0\",\"consumables.edit\":\"0\",\"consumables.delete\":\"0\",\"consumables.checkout\":\"0\",\"licenses.view\":\"0\",\"licenses.create\":\"0\",\"licenses.edit\":\"0\",\"licenses.delete\":\"0\",\"licenses.checkout\":\"0\",\"licenses.keys\":\"0\",\"components.view\":\"0\",\"components.create\":\"0\",\"components.edit\":\"0\",\"components.delete\":\"0\",\"components.checkout\":\"0\",\"components.checkin\":\"0\",\"kits.view\":\"0\",\"kits.create\":\"0\",\"kits.edit\":\"0\",\"kits.delete\":\"0\",\"kits.checkout\":\"0\",\"users.view\":\"0\",\"users.create\":\"0\",\"users.edit\":\"0\",\"users.delete\":\"0\",\"models.view\":\"0\",\"models.create\":\"0\",\"models.edit\":\"0\",\"models.delete\":\"0\",\"categories.view\":\"0\",\"categories.create\":\"0\",\"categories.edit\":\"0\",\"categories.delete\":\"0\",\"departments.view\":\"0\",\"departments.create\":\"0\",\"departments.edit\":\"0\",\"departments.delete\":\"0\",\"statuslabels.view\":\"0\",\"statuslabels.create\":\"0\",\"statuslabels.edit\":\"0\",\"statuslabels.delete\":\"0\",\"customfields.view\":\"0\",\"customfields.create\":\"0\",\"customfields.edit\":\"0\",\"customfields.delete\":\"0\",\"suppliers.view\":\"0\",\"suppliers.create\":\"0\",\"suppliers.edit\":\"0\",\"suppliers.delete\":\"0\",\"manufacturers.view\":\"0\",\"manufacturers.create\":\"0\",\"manufacturers.edit\":\"0\",\"manufacturers.delete\":\"0\",\"depreciations.view\":\"0\",\"depreciations.create\":\"0\",\"depreciations.edit\":\"0\",\"depreciations.delete\":\"0\",\"locations.view\":\"0\",\"locations.create\":\"0\",\"locations.edit\":\"0\",\"locations.delete\":\"0\",\"companies.view\":\"0\",\"companies.create\":\"0\",\"companies.edit\":\"0\",\"companies.delete\":\"0\",\"self.two_factor\":\"0\",\"self.api\":\"0\",\"self.edit_location\":\"0\",\"self.checkout_assets\":\"0\"}',1,NULL,NULL,NULL,NULL,NULL,'Claire','Palmer','2021-02-23 10:35:40','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'Claire.Palmer',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(9,'graeme.frankland@tvg.uk','$2y$10$nnSaEcdLYtgcd7pahHPpWeN3kI6K1vUkiGMC6Pl8fRMJ73pk4mOee',NULL,1,NULL,NULL,NULL,NULL,NULL,'Graeme','Frankland','2021-02-23 10:35:40','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'graeme.frankland',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(10,'','$2y$10$nnSaEcdLYtgcd7pahHPpWeN3kI6K1vUkiGMC6Pl8fRMJ73pk4mOee',NULL,1,NULL,NULL,NULL,NULL,NULL,'Miles','Frankland (Test)','2021-02-23 10:35:40','2021-10-07 12:06:13','2021-10-07 12:06:13',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'mftest',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(11,'Christopher.George@tvg.uk','$2y$10$nnSaEcdLYtgcd7pahHPpWeN3kI6K1vUkiGMC6Pl8fRMJ73pk4mOee','{\"superuser\":\"0\",\"admin\":\"0\",\"import\":\"0\",\"reports.view\":\"0\",\"assets.view\":\"0\",\"assets.create\":\"0\",\"assets.edit\":\"0\",\"assets.delete\":\"0\",\"assets.checkin\":\"0\",\"assets.checkout\":\"0\",\"assets.audit\":\"0\",\"assets.view.requestable\":\"0\",\"accessories.view\":\"0\",\"accessories.create\":\"0\",\"accessories.edit\":\"0\",\"accessories.delete\":\"0\",\"accessories.checkout\":\"0\",\"accessories.checkin\":\"0\",\"consumables.view\":\"0\",\"consumables.create\":\"0\",\"consumables.edit\":\"0\",\"consumables.delete\":\"0\",\"consumables.checkout\":\"0\",\"licenses.view\":\"0\",\"licenses.create\":\"0\",\"licenses.edit\":\"0\",\"licenses.delete\":\"0\",\"licenses.checkout\":\"0\",\"licenses.keys\":\"0\",\"components.view\":\"0\",\"components.create\":\"0\",\"components.edit\":\"0\",\"components.delete\":\"0\",\"components.checkout\":\"0\",\"components.checkin\":\"0\",\"kits.view\":\"0\",\"kits.create\":\"0\",\"kits.edit\":\"0\",\"kits.delete\":\"0\",\"kits.checkout\":\"0\",\"users.view\":\"0\",\"users.create\":\"0\",\"users.edit\":\"0\",\"users.delete\":\"0\",\"models.view\":\"0\",\"models.create\":\"0\",\"models.edit\":\"0\",\"models.delete\":\"0\",\"categories.view\":\"0\",\"categories.create\":\"0\",\"categories.edit\":\"0\",\"categories.delete\":\"0\",\"departments.view\":\"0\",\"departments.create\":\"0\",\"departments.edit\":\"0\",\"departments.delete\":\"0\",\"statuslabels.view\":\"0\",\"statuslabels.create\":\"0\",\"statuslabels.edit\":\"0\",\"statuslabels.delete\":\"0\",\"customfields.view\":\"0\",\"customfields.create\":\"0\",\"customfields.edit\":\"0\",\"customfields.delete\":\"0\",\"suppliers.view\":\"0\",\"suppliers.create\":\"0\",\"suppliers.edit\":\"0\",\"suppliers.delete\":\"0\",\"manufacturers.view\":\"0\",\"manufacturers.create\":\"0\",\"manufacturers.edit\":\"0\",\"manufacturers.delete\":\"0\",\"depreciations.view\":\"0\",\"depreciations.create\":\"0\",\"depreciations.edit\":\"0\",\"depreciations.delete\":\"0\",\"locations.view\":\"0\",\"locations.create\":\"0\",\"locations.edit\":\"0\",\"locations.delete\":\"0\",\"companies.view\":\"0\",\"companies.create\":\"0\",\"companies.edit\":\"0\",\"companies.delete\":\"0\",\"self.two_factor\":\"0\",\"self.api\":\"0\",\"self.edit_location\":\"0\",\"self.checkout_assets\":\"0\"}',1,NULL,NULL,NULL,NULL,NULL,'Chris','George','2021-02-23 10:35:40','2021-10-07 12:04:58',NULL,NULL,'',NULL,1,'','',5,'',NULL,'Christopher.George',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(12,'Timothy.Duffin@tvg.uk','$2y$10$nnSaEcdLYtgcd7pahHPpWeN3kI6K1vUkiGMC6Pl8fRMJ73pk4mOee',NULL,1,NULL,NULL,NULL,NULL,NULL,'Tim','Duffin','2021-02-23 10:35:40','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'Timothy.Duffin',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(13,'Jason.Lothian@tvg.uk','$2y$10$nnSaEcdLYtgcd7pahHPpWeN3kI6K1vUkiGMC6Pl8fRMJ73pk4mOee',NULL,1,NULL,NULL,NULL,NULL,NULL,'Jason','Lothian','2021-02-23 10:35:40','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'Jason.Lothian',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(14,'simon.findlay@tvg.uk','$2y$10$nnSaEcdLYtgcd7pahHPpWeN3kI6K1vUkiGMC6Pl8fRMJ73pk4mOee',NULL,1,NULL,NULL,NULL,NULL,NULL,'Simon','Findlay','2021-02-23 10:35:40','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'simon.findlay',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(15,'stephen.hoy@tvg.uk','$2y$10$nnSaEcdLYtgcd7pahHPpWeN3kI6K1vUkiGMC6Pl8fRMJ73pk4mOee',NULL,1,NULL,NULL,NULL,NULL,NULL,'Stephen','Hoy','2021-02-23 10:35:40','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'Stephen.Hoy',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(16,'Alan.Ledgeway@thevehiclegroup.com','$2y$10$nnSaEcdLYtgcd7pahHPpWeN3kI6K1vUkiGMC6Pl8fRMJ73pk4mOee',NULL,1,NULL,NULL,NULL,NULL,NULL,'Alan','Ledgeway','2021-02-23 10:35:40','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'Alan.Ledgeway',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(17,'john.deetlefs@tvg.uk','$2y$10$nnSaEcdLYtgcd7pahHPpWeN3kI6K1vUkiGMC6Pl8fRMJ73pk4mOee',NULL,1,NULL,NULL,NULL,NULL,NULL,'John','Deetlefs','2021-02-23 10:35:40','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'john.deetlefs',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(18,'John.Craven@tvg.uk','$2y$10$nnSaEcdLYtgcd7pahHPpWeN3kI6K1vUkiGMC6Pl8fRMJ73pk4mOee',NULL,1,NULL,NULL,NULL,NULL,NULL,'John','Craven','2021-02-23 10:35:40','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'John.Craven',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(19,'paul.cook@tvg.uk','$2y$10$nnSaEcdLYtgcd7pahHPpWeN3kI6K1vUkiGMC6Pl8fRMJ73pk4mOee',NULL,1,NULL,NULL,NULL,NULL,NULL,'Paul','Cook','2021-02-23 10:35:40','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'paul.cook',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(20,'Mike.Edmunds@thevehiclegroup.com','$2y$10$nnSaEcdLYtgcd7pahHPpWeN3kI6K1vUkiGMC6Pl8fRMJ73pk4mOee',NULL,1,NULL,NULL,NULL,NULL,NULL,'Mike','Edmunds','2021-02-23 10:35:40','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'Mike.Edmunds',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(21,'Tom.Askew@thevehiclegroup.com','$2y$10$NXyJd9PHyB7K0xSPt7YWTeA/OUqQ5W1KMufuZSPwCJQEm.ZaD6abm','{\"superuser\":\"0\",\"admin\":\"0\",\"import\":\"0\",\"reports.view\":\"0\",\"assets.view\":\"0\",\"assets.create\":\"0\",\"assets.edit\":\"0\",\"assets.delete\":\"0\",\"assets.checkin\":\"0\",\"assets.checkout\":\"0\",\"assets.audit\":\"0\",\"assets.view.requestable\":\"0\",\"accessories.view\":\"0\",\"accessories.create\":\"0\",\"accessories.edit\":\"0\",\"accessories.delete\":\"0\",\"accessories.checkout\":\"0\",\"accessories.checkin\":\"0\",\"consumables.view\":\"0\",\"consumables.create\":\"0\",\"consumables.edit\":\"0\",\"consumables.delete\":\"0\",\"consumables.checkout\":\"0\",\"licenses.view\":\"0\",\"licenses.create\":\"0\",\"licenses.edit\":\"0\",\"licenses.delete\":\"0\",\"licenses.checkout\":\"0\",\"licenses.keys\":\"0\",\"components.view\":\"0\",\"components.create\":\"0\",\"components.edit\":\"0\",\"components.delete\":\"0\",\"components.checkout\":\"0\",\"components.checkin\":\"0\",\"kits.view\":\"0\",\"kits.create\":\"0\",\"kits.edit\":\"0\",\"kits.delete\":\"0\",\"kits.checkout\":\"0\",\"users.view\":\"0\",\"users.create\":\"0\",\"users.edit\":\"0\",\"users.delete\":\"0\",\"models.view\":\"0\",\"models.create\":\"0\",\"models.edit\":\"0\",\"models.delete\":\"0\",\"categories.view\":\"0\",\"categories.create\":\"0\",\"categories.edit\":\"0\",\"categories.delete\":\"0\",\"departments.view\":\"0\",\"departments.create\":\"0\",\"departments.edit\":\"0\",\"departments.delete\":\"0\",\"statuslabels.view\":\"0\",\"statuslabels.create\":\"0\",\"statuslabels.edit\":\"0\",\"statuslabels.delete\":\"0\",\"customfields.view\":\"0\",\"customfields.create\":\"0\",\"customfields.edit\":\"0\",\"customfields.delete\":\"0\",\"suppliers.view\":\"0\",\"suppliers.create\":\"0\",\"suppliers.edit\":\"0\",\"suppliers.delete\":\"0\",\"manufacturers.view\":\"0\",\"manufacturers.create\":\"0\",\"manufacturers.edit\":\"0\",\"manufacturers.delete\":\"0\",\"depreciations.view\":\"0\",\"depreciations.create\":\"0\",\"depreciations.edit\":\"0\",\"depreciations.delete\":\"0\",\"locations.view\":\"0\",\"locations.create\":\"0\",\"locations.edit\":\"0\",\"locations.delete\":\"0\",\"companies.view\":\"0\",\"companies.create\":\"0\",\"companies.edit\":\"0\",\"companies.delete\":\"0\",\"self.two_factor\":\"0\",\"self.api\":\"0\",\"self.edit_location\":\"0\",\"self.checkout_assets\":\"0\"}',1,NULL,NULL,'2021-05-14 14:09:21',NULL,NULL,'Tom','Askew','2021-03-04 13:29:05','2021-10-07 12:07:15','2021-10-07 12:07:15',NULL,NULL,NULL,NULL,NULL,'Engineering Technician',NULL,NULL,NULL,'Tom.Askew','Imported on first login from LDAP2',NULL,'3GXtE2eFnlySj7uIksNDeHdwI3JevdCVkaLYAIoyM60huYMLgV3RfporalQI',1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(22,'Gavin.Ledgeway@thevehiclegroup.com','$2y$10$nJ4ZyVgvqVhrkZJ.jkgRuO6JN8Ihipc21a14mSfgT1Qi56mLIaZV6',NULL,1,NULL,NULL,NULL,NULL,NULL,'Gavin','Ledgeway','2021-03-04 13:29:05','2021-10-07 12:05:29','2021-10-07 12:05:29',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'Gavin.Ledgeway',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(23,'Nick.Maltby@thevehiclegroup.com','$2y$10$lvCnvHqWRJzBmIMRYUBgLech3/hbHdw6XXVqDZK9E/d0gKV2UXx4y',NULL,1,NULL,NULL,NULL,NULL,NULL,'Nick','Maltby','2021-03-04 14:00:04','2021-10-07 12:06:51','2021-10-07 12:06:51',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'nick.maltby',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(24,'Stephen.Richmond@thevehiclegroup.com','$2y$10$lvCnvHqWRJzBmIMRYUBgLech3/hbHdw6XXVqDZK9E/d0gKV2UXx4y',NULL,1,NULL,NULL,NULL,NULL,NULL,'Stephen','Richmond','2021-03-04 14:00:04','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'stephen.richmond',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(25,'David.Bennett@thevehiclegroup.com','$2y$10$lvCnvHqWRJzBmIMRYUBgLech3/hbHdw6XXVqDZK9E/d0gKV2UXx4y',NULL,1,NULL,NULL,NULL,NULL,NULL,'David','Bennett','2021-03-04 14:00:04','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'david.bennett',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(26,'Kelly.Strawbridge@thevehiclegroup.com','$2y$10$lvCnvHqWRJzBmIMRYUBgLech3/hbHdw6XXVqDZK9E/d0gKV2UXx4y',NULL,1,NULL,NULL,NULL,NULL,NULL,'Kelly','Strawbridge','2021-03-04 14:00:04','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'Kelly.Strawbridge',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(27,'Jack.Morris@thevehiclegroup.com','$2y$10$lvCnvHqWRJzBmIMRYUBgLech3/hbHdw6XXVqDZK9E/d0gKV2UXx4y',NULL,1,NULL,NULL,NULL,NULL,NULL,'Jack','Morris','2021-03-04 14:00:04','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'jack.morris',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(28,'kevin.jaques@tvg.uk','$2y$10$lvCnvHqWRJzBmIMRYUBgLech3/hbHdw6XXVqDZK9E/d0gKV2UXx4y',NULL,1,NULL,NULL,NULL,NULL,NULL,'Kevin','Jaques','2021-03-04 14:00:04','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'kevin.jaques',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(29,'Lawrence.Stratton@thevehiclegroup.com','$2y$10$lvCnvHqWRJzBmIMRYUBgLech3/hbHdw6XXVqDZK9E/d0gKV2UXx4y',NULL,1,NULL,NULL,NULL,NULL,NULL,'Lawrence','Stratton','2021-03-04 14:00:04','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'Lawrence.Stratton',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(30,'ryan.taylor@thevehiclegroup.com','$2y$10$lvCnvHqWRJzBmIMRYUBgLech3/hbHdw6XXVqDZK9E/d0gKV2UXx4y',NULL,1,NULL,NULL,NULL,NULL,NULL,'Ryan','Taylor','2021-03-04 14:00:04','2021-10-07 12:07:00','2021-10-07 12:07:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'ryan.taylor',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(31,'Luke.Green@thevehiclegroup.com','$2y$10$lvCnvHqWRJzBmIMRYUBgLech3/hbHdw6XXVqDZK9E/d0gKV2UXx4y',NULL,1,NULL,NULL,NULL,NULL,NULL,'Luke','Green','2021-03-04 14:00:04','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'luke.green',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(32,'Richard.Constantine@thevehiclegroup.com','$2y$10$lvCnvHqWRJzBmIMRYUBgLech3/hbHdw6XXVqDZK9E/d0gKV2UXx4y',NULL,1,NULL,NULL,NULL,NULL,NULL,'Richard','Constantine','2021-03-04 14:00:04','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'richard.constantine',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(33,'fab.lab@thevehiclegroup.com','$2y$10$lvCnvHqWRJzBmIMRYUBgLech3/hbHdw6XXVqDZK9E/d0gKV2UXx4y',NULL,1,NULL,NULL,NULL,NULL,NULL,'Fab','Lab','2021-03-04 14:00:04','2021-10-07 12:05:23','2021-10-07 12:05:23',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'fab.lab',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(34,'manuela.krech@thevehiclegroup.com','$2y$10$lvCnvHqWRJzBmIMRYUBgLech3/hbHdw6XXVqDZK9E/d0gKV2UXx4y',NULL,1,NULL,NULL,NULL,NULL,NULL,'Manuela','Krech','2021-03-04 14:00:04','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'manuela.krech',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(35,'','$2y$10$1ti.vy8hgyGKzLShqSh0v.1mjK5CDSAcr8glSKiDQRvqDCNuof.QK',NULL,1,NULL,NULL,NULL,NULL,NULL,'Antonio','Gueorguiev','2021-04-06 17:12:33','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'Antonio.Gueorguiev',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(36,'','$2y$10$1ti.vy8hgyGKzLShqSh0v.1mjK5CDSAcr8glSKiDQRvqDCNuof.QK',NULL,1,NULL,NULL,NULL,NULL,NULL,'Irena','Heslop','2021-04-06 17:12:33','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'Irena.Heslop',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(37,'','$2y$10$1ti.vy8hgyGKzLShqSh0v.1mjK5CDSAcr8glSKiDQRvqDCNuof.QK',NULL,1,NULL,NULL,NULL,NULL,NULL,'Sarah','Hilton','2021-04-06 17:12:33','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'sarah.hilton',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(38,'','$2y$10$1ti.vy8hgyGKzLShqSh0v.1mjK5CDSAcr8glSKiDQRvqDCNuof.QK',NULL,1,NULL,NULL,NULL,NULL,NULL,'Jude','Enriquez','2021-04-06 17:12:33','2021-04-06 17:12:33',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'jude.enriquez',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(39,'','$2y$10$1ti.vy8hgyGKzLShqSh0v.1mjK5CDSAcr8glSKiDQRvqDCNuof.QK',NULL,1,NULL,NULL,NULL,NULL,NULL,'Bryn','Tagg','2021-04-06 17:12:33','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'bryn.tagg',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(40,'','$2y$10$1ti.vy8hgyGKzLShqSh0v.1mjK5CDSAcr8glSKiDQRvqDCNuof.QK',NULL,1,NULL,NULL,NULL,NULL,NULL,'Mark','Hodgson','2021-04-06 17:12:33','2021-10-07 12:05:47','2021-10-07 12:05:47',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'mark.hodgson',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(41,'lockshop@tvg.uk','$2y$10$1ti.vy8hgyGKzLShqSh0v.1mjK5CDSAcr8glSKiDQRvqDCNuof.QK',NULL,1,NULL,NULL,NULL,NULL,NULL,'Lockshop','','2021-04-06 17:12:33','2021-10-07 12:05:41','2021-10-07 12:05:41',NULL,'',NULL,NULL,'','',NULL,'',NULL,'lockshop',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(42,'David.Browning@tvg.uk','$2y$10$1ti.vy8hgyGKzLShqSh0v.1mjK5CDSAcr8glSKiDQRvqDCNuof.QK','{\"superuser\":\"0\",\"admin\":\"0\",\"import\":\"0\",\"reports.view\":\"0\",\"assets.view\":\"0\",\"assets.create\":\"0\",\"assets.edit\":\"0\",\"assets.delete\":\"0\",\"assets.checkin\":\"0\",\"assets.checkout\":\"0\",\"assets.audit\":\"0\",\"assets.view.requestable\":\"0\",\"accessories.view\":\"0\",\"accessories.create\":\"0\",\"accessories.edit\":\"0\",\"accessories.delete\":\"0\",\"accessories.checkout\":\"0\",\"accessories.checkin\":\"0\",\"consumables.view\":\"0\",\"consumables.create\":\"0\",\"consumables.edit\":\"0\",\"consumables.delete\":\"0\",\"consumables.checkout\":\"0\",\"licenses.view\":\"0\",\"licenses.create\":\"0\",\"licenses.edit\":\"0\",\"licenses.delete\":\"0\",\"licenses.checkout\":\"0\",\"licenses.keys\":\"0\",\"components.view\":\"0\",\"components.create\":\"0\",\"components.edit\":\"0\",\"components.delete\":\"0\",\"components.checkout\":\"0\",\"components.checkin\":\"0\",\"kits.view\":\"0\",\"kits.create\":\"0\",\"kits.edit\":\"0\",\"kits.delete\":\"0\",\"kits.checkout\":\"0\",\"users.view\":\"0\",\"users.create\":\"0\",\"users.edit\":\"0\",\"users.delete\":\"0\",\"models.view\":\"0\",\"models.create\":\"0\",\"models.edit\":\"0\",\"models.delete\":\"0\",\"categories.view\":\"0\",\"categories.create\":\"0\",\"categories.edit\":\"0\",\"categories.delete\":\"0\",\"departments.view\":\"0\",\"departments.create\":\"0\",\"departments.edit\":\"0\",\"departments.delete\":\"0\",\"statuslabels.view\":\"0\",\"statuslabels.create\":\"0\",\"statuslabels.edit\":\"0\",\"statuslabels.delete\":\"0\",\"customfields.view\":\"0\",\"customfields.create\":\"0\",\"customfields.edit\":\"0\",\"customfields.delete\":\"0\",\"suppliers.view\":\"0\",\"suppliers.create\":\"0\",\"suppliers.edit\":\"0\",\"suppliers.delete\":\"0\",\"manufacturers.view\":\"0\",\"manufacturers.create\":\"0\",\"manufacturers.edit\":\"0\",\"manufacturers.delete\":\"0\",\"depreciations.view\":\"0\",\"depreciations.create\":\"0\",\"depreciations.edit\":\"0\",\"depreciations.delete\":\"0\",\"locations.view\":\"0\",\"locations.create\":\"0\",\"locations.edit\":\"0\",\"locations.delete\":\"0\",\"companies.view\":\"0\",\"companies.create\":\"0\",\"companies.edit\":\"0\",\"companies.delete\":\"0\",\"self.two_factor\":\"0\",\"self.api\":\"0\",\"self.edit_location\":\"0\",\"self.checkout_assets\":\"0\"}',1,NULL,NULL,NULL,NULL,NULL,'David','Browning','2021-04-06 17:12:33','2021-10-07 12:04:58',NULL,NULL,'',NULL,2,'','',NULL,'',NULL,'David.Browning',NULL,1,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(43,'Sandra.Jones@tvg.uk','$2y$10$1ti.vy8hgyGKzLShqSh0v.1mjK5CDSAcr8glSKiDQRvqDCNuof.QK',NULL,1,NULL,NULL,NULL,NULL,NULL,'Sandra','Jones','2021-04-06 17:12:34','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'Sandra.Jones',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(44,'tvga@thevehiclegroup.com','$2y$10$zm7OdEl.RXKkDwa93M/4X.7BHC3Rn22Q3PHR44M10d7frEb0GUxzC',NULL,1,NULL,NULL,'2021-09-21 11:47:55',NULL,NULL,'TVG','Admin','2021-09-21 11:47:55','2021-10-07 12:07:20','2021-10-07 12:07:20',NULL,NULL,NULL,NULL,'','',NULL,'',NULL,'tvga','Imported on first login from LDAP2',NULL,'T4TFb3tM34hoT8XGd4nWAuC8mghbvfChmnOfQtXlUbdrw2i8rT3QolzDfjgJ',1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(45,'Colin.Boothroyd@tvg.uk','$2y$10$zWxwNecVBezYPgGefJUb1ehaD2ihKnwO76LPgAwEHRt3dAiT.AAke',NULL,1,NULL,NULL,NULL,NULL,NULL,'Colin','Boothroyd','2021-10-07 12:04:58','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'colin.boothroyd',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(46,'Paula.Underwood@tvg.uk','$2y$10$zWxwNecVBezYPgGefJUb1ehaD2ihKnwO76LPgAwEHRt3dAiT.AAke','{\"superuser\":\"0\",\"admin\":\"0\",\"import\":\"0\",\"reports.view\":\"0\",\"assets.view\":\"0\",\"assets.create\":\"0\",\"assets.edit\":\"0\",\"assets.delete\":\"0\",\"assets.checkin\":\"0\",\"assets.checkout\":\"0\",\"assets.audit\":\"0\",\"assets.view.requestable\":\"0\",\"accessories.view\":\"0\",\"accessories.create\":\"0\",\"accessories.edit\":\"0\",\"accessories.delete\":\"0\",\"accessories.checkout\":\"0\",\"accessories.checkin\":\"0\",\"consumables.view\":\"0\",\"consumables.create\":\"0\",\"consumables.edit\":\"0\",\"consumables.delete\":\"0\",\"consumables.checkout\":\"0\",\"licenses.view\":\"0\",\"licenses.create\":\"0\",\"licenses.edit\":\"0\",\"licenses.delete\":\"0\",\"licenses.checkout\":\"0\",\"licenses.keys\":\"0\",\"licenses.files\":\"0\",\"components.view\":\"0\",\"components.create\":\"0\",\"components.edit\":\"0\",\"components.delete\":\"0\",\"components.checkout\":\"0\",\"components.checkin\":\"0\",\"kits.view\":\"0\",\"kits.create\":\"0\",\"kits.edit\":\"0\",\"kits.delete\":\"0\",\"kits.checkout\":\"0\",\"users.view\":\"0\",\"users.create\":\"0\",\"users.edit\":\"0\",\"users.delete\":\"0\",\"models.view\":\"0\",\"models.create\":\"0\",\"models.edit\":\"0\",\"models.delete\":\"0\",\"categories.view\":\"0\",\"categories.create\":\"0\",\"categories.edit\":\"0\",\"categories.delete\":\"0\",\"departments.view\":\"0\",\"departments.create\":\"0\",\"departments.edit\":\"0\",\"departments.delete\":\"0\",\"statuslabels.view\":\"0\",\"statuslabels.create\":\"0\",\"statuslabels.edit\":\"0\",\"statuslabels.delete\":\"0\",\"customfields.view\":\"0\",\"customfields.create\":\"0\",\"customfields.edit\":\"0\",\"customfields.delete\":\"0\",\"suppliers.view\":\"0\",\"suppliers.create\":\"0\",\"suppliers.edit\":\"0\",\"suppliers.delete\":\"0\",\"manufacturers.view\":\"0\",\"manufacturers.create\":\"0\",\"manufacturers.edit\":\"0\",\"manufacturers.delete\":\"0\",\"depreciations.view\":\"0\",\"depreciations.create\":\"0\",\"depreciations.edit\":\"0\",\"depreciations.delete\":\"0\",\"locations.view\":\"0\",\"locations.create\":\"0\",\"locations.edit\":\"0\",\"locations.delete\":\"0\",\"companies.view\":\"0\",\"companies.create\":\"0\",\"companies.edit\":\"0\",\"companies.delete\":\"0\",\"self.two_factor\":\"0\",\"self.api\":\"0\",\"self.edit_location\":\"0\",\"self.checkout_assets\":\"0\"}',1,NULL,NULL,NULL,NULL,NULL,'Paula','Underwood','2021-10-07 12:04:58','2021-10-07 12:23:47',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Paula.Underwood',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(47,'Colin.Brown@tvg.uk','$2y$10$zWxwNecVBezYPgGefJUb1ehaD2ihKnwO76LPgAwEHRt3dAiT.AAke',NULL,1,NULL,NULL,NULL,NULL,NULL,'Colin','Brown','2021-10-07 12:04:58','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'Colin.Brown',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(48,'Gavin.Rhodes@tvg.uk','$2y$10$zWxwNecVBezYPgGefJUb1ehaD2ihKnwO76LPgAwEHRt3dAiT.AAke',NULL,1,NULL,NULL,NULL,NULL,NULL,'Gavin','Rhodes','2021-10-07 12:04:58','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'Gavin.Rhodes',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(49,'Dragos.Berbecaru@thevehiclegroup.com','$2y$10$zWxwNecVBezYPgGefJUb1ehaD2ihKnwO76LPgAwEHRt3dAiT.AAke',NULL,1,NULL,NULL,NULL,NULL,NULL,'Dragos','Berbecaru','2021-10-07 12:04:58','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'Dragos.Berbecaru',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(50,'','$2y$10$zWxwNecVBezYPgGefJUb1ehaD2ihKnwO76LPgAwEHRt3dAiT.AAke',NULL,1,NULL,NULL,NULL,NULL,NULL,'Mark','Webster','2021-10-07 12:04:58','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'Mark.Webster',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(51,'Adam.Hodgson@thevehiclegroup.com','$2y$10$zWxwNecVBezYPgGefJUb1ehaD2ihKnwO76LPgAwEHRt3dAiT.AAke',NULL,1,NULL,NULL,NULL,NULL,NULL,'Adam','Hodgson','2021-10-07 12:04:58','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'Adam.Hodgson',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(52,'Nigel.Walker@thevehiclegroup.com','$2y$10$zWxwNecVBezYPgGefJUb1ehaD2ihKnwO76LPgAwEHRt3dAiT.AAke',NULL,1,NULL,NULL,NULL,NULL,NULL,'Nigel','Walker','2021-10-07 12:04:58','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'Nigel.Walker',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(53,'Matthew.Carrick@thevehiclegroup.com','$2y$10$..iGAvAMDehsvcW3WBVDXOpIUTQ.8leaa9.uxEcG3DGv2HY.6enzi','{\"superuser\":\"0\",\"admin\":\"0\",\"import\":\"0\",\"reports.view\":\"0\",\"assets.view\":\"0\",\"assets.create\":\"0\",\"assets.edit\":\"0\",\"assets.delete\":\"0\",\"assets.checkin\":\"0\",\"assets.checkout\":\"0\",\"assets.audit\":\"0\",\"assets.view.requestable\":\"0\",\"accessories.view\":\"0\",\"accessories.create\":\"0\",\"accessories.edit\":\"0\",\"accessories.delete\":\"0\",\"accessories.checkout\":\"0\",\"accessories.checkin\":\"0\",\"consumables.view\":\"0\",\"consumables.create\":\"0\",\"consumables.edit\":\"0\",\"consumables.delete\":\"0\",\"consumables.checkout\":\"0\",\"licenses.view\":\"0\",\"licenses.create\":\"0\",\"licenses.edit\":\"0\",\"licenses.delete\":\"0\",\"licenses.checkout\":\"0\",\"licenses.keys\":\"0\",\"licenses.files\":\"0\",\"components.view\":\"0\",\"components.create\":\"0\",\"components.edit\":\"0\",\"components.delete\":\"0\",\"components.checkout\":\"0\",\"components.checkin\":\"0\",\"kits.view\":\"0\",\"kits.create\":\"0\",\"kits.edit\":\"0\",\"kits.delete\":\"0\",\"kits.checkout\":\"0\",\"users.view\":\"0\",\"users.create\":\"0\",\"users.edit\":\"0\",\"users.delete\":\"0\",\"models.view\":\"0\",\"models.create\":\"0\",\"models.edit\":\"0\",\"models.delete\":\"0\",\"categories.view\":\"0\",\"categories.create\":\"0\",\"categories.edit\":\"0\",\"categories.delete\":\"0\",\"departments.view\":\"0\",\"departments.create\":\"0\",\"departments.edit\":\"0\",\"departments.delete\":\"0\",\"statuslabels.view\":\"0\",\"statuslabels.create\":\"0\",\"statuslabels.edit\":\"0\",\"statuslabels.delete\":\"0\",\"customfields.view\":\"0\",\"customfields.create\":\"0\",\"customfields.edit\":\"0\",\"customfields.delete\":\"0\",\"suppliers.view\":\"0\",\"suppliers.create\":\"0\",\"suppliers.edit\":\"0\",\"suppliers.delete\":\"0\",\"manufacturers.view\":\"0\",\"manufacturers.create\":\"0\",\"manufacturers.edit\":\"0\",\"manufacturers.delete\":\"0\",\"depreciations.view\":\"0\",\"depreciations.create\":\"0\",\"depreciations.edit\":\"0\",\"depreciations.delete\":\"0\",\"locations.view\":\"0\",\"locations.create\":\"0\",\"locations.edit\":\"0\",\"locations.delete\":\"0\",\"companies.view\":\"0\",\"companies.create\":\"0\",\"companies.edit\":\"0\",\"companies.delete\":\"0\",\"self.two_factor\":\"0\",\"self.api\":\"0\",\"self.edit_location\":\"0\",\"self.checkout_assets\":\"0\"}',1,NULL,NULL,'2022-05-27 10:04:47',NULL,NULL,'Matthew','Carrick','2021-10-07 12:04:58','2022-05-27 10:04:47',NULL,NULL,NULL,NULL,5,NULL,NULL,6,NULL,NULL,'Matthew.Carrick',NULL,1,NULL,1,'en-GB',1,NULL,0,0,4,NULL,NULL,NULL,NULL,NULL,0),(54,'Przemyslaw.Rzepka@thevehiclegroup.com','$2y$10$zWxwNecVBezYPgGefJUb1ehaD2ihKnwO76LPgAwEHRt3dAiT.AAke',NULL,1,NULL,NULL,NULL,NULL,NULL,'Przemyslaw','Rzepka','2021-10-07 12:04:58','2021-10-07 12:04:58',NULL,NULL,'',NULL,NULL,'','',NULL,'',NULL,'Przemyslaw.Rzepka',NULL,NULL,NULL,1,'en-GB',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0),(55,'Simon.Giles@thevehiclegroup.com','$2y$10$ZHgELjwGLysHPkzRxoGZEuuCnciBY2VGYTBw89tzzJ9yQJfIUyTTy','{\"superuser\":\"0\",\"admin\":\"0\",\"import\":\"0\",\"reports.view\":\"0\",\"assets.view\":\"0\",\"assets.create\":\"0\",\"assets.edit\":\"0\",\"assets.delete\":\"0\",\"assets.checkin\":\"0\",\"assets.checkout\":\"0\",\"assets.audit\":\"0\",\"assets.view.requestable\":\"0\",\"accessories.view\":\"0\",\"accessories.create\":\"0\",\"accessories.edit\":\"0\",\"accessories.delete\":\"0\",\"accessories.checkout\":\"0\",\"accessories.checkin\":\"0\",\"consumables.view\":\"0\",\"consumables.create\":\"0\",\"consumables.edit\":\"0\",\"consumables.delete\":\"0\",\"consumables.checkout\":\"0\",\"licenses.view\":\"0\",\"licenses.create\":\"0\",\"licenses.edit\":\"0\",\"licenses.delete\":\"0\",\"licenses.checkout\":\"0\",\"licenses.keys\":\"0\",\"licenses.files\":\"0\",\"components.view\":\"0\",\"components.create\":\"0\",\"components.edit\":\"0\",\"components.delete\":\"0\",\"components.checkout\":\"0\",\"components.checkin\":\"0\",\"kits.view\":\"0\",\"kits.create\":\"0\",\"kits.edit\":\"0\",\"kits.delete\":\"0\",\"kits.checkout\":\"0\",\"users.view\":\"0\",\"users.create\":\"0\",\"users.edit\":\"0\",\"users.delete\":\"0\",\"models.view\":\"0\",\"models.create\":\"0\",\"models.edit\":\"0\",\"models.delete\":\"0\",\"categories.view\":\"0\",\"categories.create\":\"0\",\"categories.edit\":\"0\",\"categories.delete\":\"0\",\"departments.view\":\"0\",\"departments.create\":\"0\",\"departments.edit\":\"0\",\"departments.delete\":\"0\",\"statuslabels.view\":\"0\",\"statuslabels.create\":\"0\",\"statuslabels.edit\":\"0\",\"statuslabels.delete\":\"0\",\"customfields.view\":\"0\",\"customfields.create\":\"0\",\"customfields.edit\":\"0\",\"customfields.delete\":\"0\",\"suppliers.view\":\"0\",\"suppliers.create\":\"0\",\"suppliers.edit\":\"0\",\"suppliers.delete\":\"0\",\"manufacturers.view\":\"0\",\"manufacturers.create\":\"0\",\"manufacturers.edit\":\"0\",\"manufacturers.delete\":\"0\",\"depreciations.view\":\"0\",\"depreciations.create\":\"0\",\"depreciations.edit\":\"0\",\"depreciations.delete\":\"0\",\"locations.view\":\"0\",\"locations.create\":\"0\",\"locations.edit\":\"0\",\"locations.delete\":\"0\",\"companies.view\":\"0\",\"companies.create\":\"0\",\"companies.edit\":\"0\",\"companies.delete\":\"0\",\"self.two_factor\":\"0\",\"self.api\":\"0\",\"self.edit_location\":\"0\",\"self.checkout_assets\":\"0\"}',1,NULL,NULL,'2022-05-27 08:32:31',NULL,NULL,'Simon','Giles','2021-10-07 12:04:58','2022-05-27 08:32:31',NULL,NULL,NULL,NULL,6,NULL,NULL,6,NULL,NULL,'Simon.Giles',NULL,1,'rpQSzoGwZXPU9aTgKORGTUVdi2su07jj6xgoTYw4LD0al4VegiYdtth7ws83',1,'en-GB',1,NULL,0,0,5,NULL,NULL,NULL,NULL,NULL,0);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `users_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users_groups` (
  `user_id` int unsigned NOT NULL,
  `group_id` int unsigned NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `users_groups` WRITE;
/*!40000 ALTER TABLE `users_groups` DISABLE KEYS */;
INSERT INTO `users_groups` VALUES (1,1),(8,1),(21,1),(46,1),(53,1),(55,1);
/*!40000 ALTER TABLE `users_groups` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

